/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process;

import org.jbpm.process.core.Work;
import org.jbpm.process.core.impl.WorkImpl;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.test.TestProcessEventListener;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.LoggerFactory;

public class SubProcessTest
extends AbstractBaseTest {
    private boolean executed = false;
    private WorkItem workItem;
    String[] syncEventorder = new String[]{"bps", "bnt-0", "bnl-0", "bnt-1", "bps", "bnt-0", "bnl-0", "bnt-1", "bnl-1", "bnt-2", "bnl-2", "bpc", "apc", "anl-2", "ant-2", "anl-1", "ant-1", "anl-0", "ant-0", "aps", "bnl-1", "bnt-2", "bnl-2", "bpc", "apc", "anl-2", "ant-2", "anl-1", "ant-1", "anl-0", "ant-0", "aps"};
    String[] asyncEventOrder = new String[]{"bnl-1", "bnt-2", "bnl-2", "bpc", "apc", "bnl-1", "bnt-2", "bnl-2", "bpc", "apc", "anl-2", "ant-2", "anl-1", "anl-2", "ant-2", "anl-1"};

    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Before
    public void setUp() {
        this.executed = false;
        this.workItem = null;
    }

    @Test
    public void testSynchronousSubProcess() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.process");
        process.setName("Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(2L);
        process.addNode((Node)endNode);
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setName("SubProcessNode");
        subProcessNode.setId(3L);
        subProcessNode.setProcessId("org.drools.core.process.subprocess");
        process.addNode((Node)subProcessNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)subProcessNode, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)subProcessNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        RuleFlowProcess subprocess = new RuleFlowProcess();
        subprocess.setId("org.drools.core.process.subprocess");
        subprocess.setName("SubProcess");
        startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        subprocess.addNode((Node)startNode);
        endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(2L);
        subprocess.addNode((Node)endNode);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                SubProcessTest.this.logger.info("Executed action");
                SubProcessTest.this.executed = true;
            }
        });
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(3L);
        subprocess.addNode((Node)actionNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        KieSession ksession = this.createKieSession(new Process[]{process, subprocess});
        TestProcessEventListener procEventListener = new TestProcessEventListener();
        ksession.addEventListener((ProcessEventListener)procEventListener);
        ksession.startProcess("org.drools.core.process.process");
        Assert.assertTrue((boolean)this.executed);
        Assert.assertEquals((long)0L, (long)ksession.getProcessInstances().size());
        this.verifyEventHistory(this.syncEventorder, procEventListener.getEventHistory());
    }

    @Test
    public void testAsynchronousSubProcess() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.process");
        process.setName("Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(2L);
        process.addNode((Node)endNode);
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setName("SubProcessNode");
        subProcessNode.setId(3L);
        subProcessNode.setProcessId("org.drools.core.process.subprocess");
        process.addNode((Node)subProcessNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)subProcessNode, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)subProcessNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        RuleFlowProcess subProcess = new RuleFlowProcess();
        subProcess.setId("org.drools.core.process.subprocess");
        subProcess.setName("SubProcess");
        startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        subProcess.addNode((Node)startNode);
        endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(2L);
        subProcess.addNode((Node)endNode);
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setName("WorkItem");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        workItemNode.setId(4L);
        subProcess.addNode((Node)workItemNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        KieSession ksession = this.createKieSession(new Process[]{process, subProcess});
        ksession.getWorkItemManager().registerWorkItemHandler("MyWork", new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                SubProcessTest.this.logger.info("Executing work item");
                SubProcessTest.this.workItem = workItem;
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            }
        });
        ksession.startProcess("org.drools.core.process.process");
        TestProcessEventListener procEventListener = new TestProcessEventListener();
        ksession.addEventListener((ProcessEventListener)procEventListener);
        Assert.assertNotNull((Object)this.workItem);
        Assert.assertEquals((long)2L, (long)ksession.getProcessInstances().size());
        ksession.getWorkItemManager().completeWorkItem(this.workItem.getId(), null);
        Assert.assertEquals((long)0L, (long)ksession.getProcessInstances().size());
        this.verifyEventHistory(this.asyncEventOrder, procEventListener.getEventHistory());
    }

    @Test
    public void testNonExistentSubProcess() {
        String nonExistentSubProcessName = "nonexistent.process";
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.process");
        process.setName("Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setName("SubProcessNode");
        subProcessNode.setId(2L);
        subProcessNode.setProcessId(nonExistentSubProcessName);
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        this.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)subProcessNode);
        this.connect((org.jbpm.workflow.core.Node)subProcessNode, (org.jbpm.workflow.core.Node)endNode);
        process.addNode((Node)startNode);
        process.addNode((Node)subProcessNode);
        process.addNode((Node)endNode);
        KieSession ksession = this.createKieSession(new Process[]{process});
        try {
            ksession.startProcess("org.drools.core.process.process");
            Assert.fail((String)"should throw exception");
        }
        catch (RuntimeException re) {
            Assert.assertTrue((boolean)re.getMessage().contains(nonExistentSubProcessName));
        }
    }

    private void connect(org.jbpm.workflow.core.Node sourceNode, org.jbpm.workflow.core.Node targetNode) {
        new ConnectionImpl((Node)sourceNode, "DROOLS_DEFAULT", (Node)targetNode, "DROOLS_DEFAULT");
    }
}

