/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.BooleanDataType;
import org.jbpm.process.core.datatype.impl.type.FloatDataType;
import org.jbpm.process.core.datatype.impl.type.IntegerDataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.datatype.impl.type.StringDataType;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.instance.node.RuleSetNodeInstance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class RuleSetInstanceTest
extends AbstractBaseTest {
    RuleSetNodeInstance ruleSetNodeInstance;
    RuleSetNode mockRuleSetNode;
    VariableScopeInstance variableScopeInstance;
    VariableScope variableScope;
    private final String sourceName;
    private final String targetName;
    private final Object sourceObject;
    private final Object targetObject;
    private final DataType variableDataType;
    private final String targetDataType;

    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Parameterized.Parameters(name="{index}: Actual: <{0}> Expected: <{1}> Type: <{3}>")
    public static Collection<Object[]> data() {
        String className = "org.jbpm.workflow.instance.node.RuleSetInstanceTest$MyDataObject";
        HashMap<String, Object> sourceMap = new HashMap<String, Object>();
        sourceMap.put("message", "abc");
        sourceMap.put("status", true);
        sourceMap.put("code", 1);
        MyDataObject targetDataObject = new MyDataObject("abc", true, 1);
        return Arrays.asList({"abc", "abc", new StringDataType(), "java.lang.String"}, {true, true, new BooleanDataType(), "java.lang.Boolean"}, {"true", true, new BooleanDataType(), "java.lang.Boolean"}, {123, 123, new IntegerDataType(), "java.lang.Integer"}, {"123", 123, new IntegerDataType(), "java.lang.Integer"}, {12.3, 12.3, new ObjectDataType(), "java.lang.Double"}, {"12.3", Float.valueOf(12.3f), new FloatDataType(), "java.lang.Float"}, {sourceMap, targetDataObject, new ObjectDataType(className), className});
    }

    public RuleSetInstanceTest(Object sourceObject, Object targetObject, DataType variableDataType, String targetDataType) {
        this.sourceName = "sourceName";
        this.targetName = "targetName";
        this.sourceObject = sourceObject;
        this.targetObject = targetObject;
        this.variableDataType = variableDataType;
        this.targetDataType = targetDataType;
    }

    @Before
    public void setup() {
        this.ruleSetNodeInstance = (RuleSetNodeInstance)Mockito.spy(RuleSetNodeInstance.class);
        this.mockRuleSetNode = (RuleSetNode)Mockito.mock(RuleSetNode.class);
        ((RuleSetNodeInstance)Mockito.doReturn((Object)this.mockRuleSetNode).when((Object)this.ruleSetNodeInstance)).getRuleSetNode();
        this.variableScopeInstance = (VariableScopeInstance)Mockito.mock(VariableScopeInstance.class);
        ((RuleSetNodeInstance)Mockito.doReturn((Object)this.variableScopeInstance).when((Object)this.ruleSetNodeInstance)).resolveContextInstance((String)ArgumentMatchers.any(), ArgumentMatchers.any());
    }

    @Test
    public void testProcessOutputs() {
        ArrayList assignments = new ArrayList();
        DataAssociation dataAssociation = new DataAssociation(this.sourceName, this.targetName, assignments, null);
        ArrayList<DataAssociation> dataAssociations = new ArrayList<DataAssociation>();
        dataAssociations.add(dataAssociation);
        ((RuleSetNode)Mockito.doReturn(dataAssociations).when((Object)this.mockRuleSetNode)).getOutAssociations();
        Variable variable = new Variable();
        variable.setName(this.targetName);
        variable.setType(this.variableDataType);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        variables.add(variable);
        this.variableScope = new VariableScope();
        this.variableScope.setVariables(variables);
        ((VariableScopeInstance)Mockito.doReturn((Object)this.variableScope).when((Object)this.variableScopeInstance)).getVariableScope();
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put(this.sourceName, this.sourceObject);
        this.ruleSetNodeInstance.processOutputs(outputs);
        ArgumentCaptor targetCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor valueCaptor = ArgumentCaptor.forClass(Object.class);
        ((VariableScopeInstance)Mockito.verify((Object)this.variableScopeInstance, (VerificationMode)Mockito.times((int)1))).setVariable((String)targetCaptor.capture(), valueCaptor.capture());
        Assertions.assertThat((String)((String)targetCaptor.getValue())).isEqualTo(this.targetName);
        Assertions.assertThat((String)valueCaptor.getValue().getClass().getTypeName()).isEqualTo(this.targetDataType);
        Assertions.assertThat((Object)valueCaptor.getValue()).isEqualToComparingFieldByField(this.targetObject);
    }

    public static class MyDataObject {
        private String message;
        private Boolean status;
        private Integer code;

        public MyDataObject() {
        }

        public MyDataObject(String message, Boolean status, Integer code) {
            this.message = message;
            this.status = status;
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Boolean getStatus() {
            return this.status;
        }

        public void setStatus(Boolean status) {
            this.status = status;
        }

        public Integer getCode() {
            return this.code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String toString() {
            return "MyDataObject{message='" + this.message + '\'' + ", status=" + this.status + ", code=" + this.code + '}';
        }
    }
}

