/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.junit.Test;

public class ObjectDataTypeTest {
    @Test
    public void testReadValueNull() {
        ObjectDataType dateType = new ObjectDataType(Date.class.getCanonicalName());
        Assertions.assertThat((Object)dateType.readValue(null)).isNull();
        Assertions.assertThat((Object)dateType.valueOf(null)).isNull();
        Assertions.assertThat((boolean)dateType.verifyDataType(null)).isTrue();
    }

    @Test
    public void testReadValueDate() {
        ObjectDataType dateType = new ObjectDataType(Date.class.getCanonicalName());
        Assertions.assertThat((Object)dateType.readValue("2012-02-02")).isInstanceOf(Date.class);
        Assertions.assertThat((Object)dateType.readValue("12:12:12")).isInstanceOf(Date.class);
        Assertions.assertThat((Object)dateType.valueOf("2012-02-02")).isInstanceOf(Date.class);
        Assertions.assertThat((Object)dateType.valueOf("12:12:12")).isInstanceOf(Date.class);
        ((AbstractDateAssert)((ObjectAssert)Assertions.assertThat((Object)dateType.valueOf("2016-01-11T01:06:32")).isInstanceOf(Date.class)).asInstanceOf(InstanceOfAssertFactories.DATE)).hasHourOfDay(1).hasMinute(6).hasSecond(32);
        Assertions.assertThat((Object)dateType.valueOf("pepe")).isInstanceOf(String.class);
        Assertions.assertThatThrownBy(() -> dateType.readValue("pepe")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testReadValueLocalDate() {
        ObjectDataType dateType = new ObjectDataType(LocalDate.class.getCanonicalName());
        Assertions.assertThat((Object)dateType.readValue("2012-02-02")).isInstanceOf(LocalDate.class);
        Assertions.assertThat((Object)dateType.valueOf("2012-02-02")).isInstanceOf(LocalDate.class);
    }

    @Test
    public void testReadValueLocalDateTime() {
        ObjectDataType dateType = new ObjectDataType(LocalDateTime.class.getCanonicalName());
        Assertions.assertThat((Object)dateType.readValue("2012-02-02T12:12:12")).isInstanceOf(LocalDateTime.class);
        Assertions.assertThat((Object)dateType.valueOf("2012-02-02T12:12:12")).isInstanceOf(LocalDateTime.class);
    }

    @Test
    public void testReadValueZonedDateTime() {
        ObjectDataType dateType = new ObjectDataType(ZonedDateTime.class.getCanonicalName());
        Assertions.assertThat((Object)dateType.readValue("2012-02-02T12:12:12+00:01")).isInstanceOf(ZonedDateTime.class);
        Assertions.assertThat((Object)dateType.valueOf("2012-02-02T12:12:12+00:01")).isInstanceOf(ZonedDateTime.class);
    }
}

