/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.command;

import java.util.ArrayList;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.runtime.process.ProcessRuntimeFactory;
import org.drools.core.runtime.process.ProcessRuntimeFactoryService;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessRuntimeFactoryServiceImpl;
import org.jbpm.process.instance.command.UpdateTimerCommand;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessDataChangedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.RegistryContext;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;

public class UpdateTimerCommandTest
extends AbstractBaseTest {
    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testUpdateTimerCommand() throws Exception {
        long processInstanceId = 1234L;
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession workingMemory = kbase.newKieSession();
        InternalProcessRuntime processRuntime = (InternalProcessRuntime)((InternalWorkingMemory)workingMemory).getProcessRuntime();
        final ArrayList processEventList = new ArrayList();
        ProcessEventListener processEventListener = new ProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }

            public void onProcessDataChangedEvent(ProcessDataChangedEvent event) {
                processEventList.add(event);
            }
        };
        workingMemory.addEventListener(processEventListener);
        RuleFlowProcessInstance processInstance = new RuleFlowProcessInstance();
        processInstance.setKnowledgeRuntime(((InternalWorkingMemory)workingMemory).getKnowledgeRuntime());
        processInstance.setId(processInstanceId);
        TimerManager timerManager = ((InternalProcessRuntime)((InternalWorkingMemory)workingMemory).getProcessRuntime()).getTimerManager();
        TimerInstance timer = new TimerInstance();
        timer.setDelay(100000L);
        timerManager.registerTimer(timer, (ProcessInstance)processInstance);
        processInstance.internalSetSlaTimerId(Long.valueOf(timer.getId()));
        processRuntime.getProcessInstanceManager().internalAddProcessInstance((org.kie.api.runtime.process.ProcessInstance)processInstance);
        RegistryContext mockContext = (RegistryContext)Mockito.mock(RegistryContext.class);
        Mockito.when((Object)((KieSession)mockContext.lookup(KieSession.class))).thenReturn((Object)workingMemory);
        UpdateTimerCommand command = new UpdateTimerCommand(processInstance.getId(), timer.getId(), timer.getDelay(), timer.getPeriod(), timer.getRepeatLimit());
        command.execute((Context)mockContext);
        Assert.assertEquals((long)1L, (long)processEventList.size());
        Assert.assertTrue((boolean)(processEventList.get(0) instanceof ProcessDataChangedEvent));
        Assert.assertEquals((long)processInstanceId, (long)((ProcessDataChangedEvent)processEventList.get(0)).getProcessInstance().getId());
        timerManager.cancelTimer(processInstanceId, timer.getId());
    }

    static {
        ProcessRuntimeFactory.setProcessRuntimeFactoryService((ProcessRuntimeFactoryService)new ProcessRuntimeFactoryServiceImpl());
    }
}

