/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.WorkflowProcessInstance;

public class CancelNodeInstanceAction
implements Action,
Serializable {
    private static final long serialVersionUID = 1L;
    private String attachedToNodeId;

    public CancelNodeInstanceAction(String attachedToNodeId) {
        this.attachedToNodeId = attachedToNodeId;
    }

    @Override
    public void execute(ProcessContext context) throws Exception {
        NodeInstanceContainer container = context.getNodeInstance().getNodeInstanceContainer();
        Collection<NodeInstance> nodeInstances = this.findNodeByUniqueId(container.getNodeInstances(), this.attachedToNodeId);
        if (nodeInstances.isEmpty()) {
            WorkflowProcessInstance pi = context.getNodeInstance().getProcessInstance();
            nodeInstances = this.findNodeByUniqueId(pi.getNodeInstances(), this.attachedToNodeId);
        }
        nodeInstances.forEach(nodeInstance -> ((org.jbpm.workflow.instance.NodeInstance)nodeInstance).cancel(NodeInstance.CancelType.SKIPPED));
    }

    private Collection<NodeInstance> findNodeByUniqueId(Collection<NodeInstance> nodeInstances, String uniqueId) {
        HashSet<NodeInstance> result = new HashSet<NodeInstance>();
        if (nodeInstances != null && !nodeInstances.isEmpty()) {
            for (NodeInstance nInstance : nodeInstances) {
                String nodeUniqueId = (String)nInstance.getNode().getMetaData().get("UniqueId");
                if (uniqueId.equals(nodeUniqueId)) {
                    result.add(nInstance);
                }
                if (!(nInstance instanceof CompositeNodeInstance)) continue;
                result.addAll(this.findNodeByUniqueId(((CompositeNodeInstance)nInstance).getNodeInstances(), uniqueId));
            }
        }
        return result;
    }
}

