/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.designer.integration.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.UserTask;
import org.jbpm.formModeler.api.model.DataHolder;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.config.DataHolderManager;
import org.jbpm.formModeler.core.config.FieldTypeManager;
import org.jbpm.formModeler.core.config.FormManager;
import org.jbpm.formModeler.core.config.FormSerializationManager;
import org.jbpm.formModeler.core.config.builders.dataHolder.DataHolderBuildConfig;
import org.jbpm.formModeler.core.config.builders.dataHolder.DataHolderBuilder;
import org.jbpm.formModeler.designer.integration.BPMNFormBuilderService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class BPMNFormBuilderServiceImpl
implements BPMNFormBuilderService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private FormManager formManager;
    @Inject
    private FormSerializationManager formSerializationManager;
    @Inject
    private DataHolderManager dataHolderManager;
    @Inject
    private FieldTypeManager fieldTypeManager;

    @Override
    public String buildEmptyFormXML(String fileName) {
        Form form = this.formManager.createForm(fileName);
        String xmlForm = this.formSerializationManager.generateFormXML(form);
        return xmlForm;
    }

    @Override
    public String buildFormXML(org.uberfire.backend.vfs.Path base, String fileName, String uri, Definitions source, String id) throws Exception {
        Set<DataHolder> holders;
        Form form;
        org.uberfire.backend.vfs.Path formPath = PathFactory.newPathBasedOn((String)fileName, (String)uri, (org.uberfire.backend.vfs.Path)base);
        Path kiePath = Paths.convert((org.uberfire.backend.vfs.Path)formPath);
        if (!this.ioService.exists(kiePath)) {
            form = this.formManager.createForm(fileName);
            holders = this.getDataHolders(source, Paths.convert((Path)kiePath.getParent()), id);
        } else {
            form = this.formSerializationManager.loadFormFromXML(this.ioService.readAllString(kiePath).trim());
            holders = this.getDataHolders(source, formPath, id);
        }
        this.addHoldersToForm(form, holders);
        return this.formSerializationManager.generateFormXML(form);
    }

    protected void addHoldersToForm(Form form, Set<DataHolder> holders) throws Exception {
        if (holders == null) {
            return;
        }
        for (DataHolder holder : holders) {
            this.formManager.addAllDataHolderFieldsToForm(form, holder);
        }
    }

    public Set<DataHolder> getDataHolders(Definitions source, org.uberfire.backend.vfs.Path context, String resourceId) {
        if (source == null || context == null) {
            return null;
        }
        HashMap<String, DataHolderBuildConfig> associations = new HashMap<String, DataHolderBuildConfig>();
        List rootElements = source.getRootElements();
        String contextUri = Paths.convert((org.uberfire.backend.vfs.Path)context).toUri().toString();
        for (RootElement re : rootElements) {
            Process process;
            if (!(re instanceof Process) || (process = (Process)re) == null || process.getId() == null || process.getId().length() <= 0) continue;
            List processProperties = process.getProperties();
            if (StringUtils.isEmpty((CharSequence)resourceId)) {
                return this.getProcessDataHolders(processProperties, contextUri);
            }
            String[] colors = this.dataHolderManager.getHolderColors().keySet().toArray(new String[0]);
            int index = 0;
            for (Property prop : processProperties) {
                String holderClass = (String)StringUtils.defaultIfEmpty((CharSequence)prop.getItemSubjectRef().getStructureRef(), (CharSequence)"java.lang.Object");
                DataHolderBuildConfig config = new DataHolderBuildConfig(prop.getId(), "", "", colors[index], holderClass);
                config.addAttribute("path", contextUri);
                associations.put(prop.getId(), config);
                if (index == colors.length - 1) {
                    index = 0;
                    continue;
                }
                ++index;
            }
            this.getDataHoldersFromElements((FlowElementsContainer)process, resourceId, associations);
        }
        TreeSet<DataHolder> result = new TreeSet<DataHolder>();
        Iterator it = associations.keySet().iterator();
        while (it.hasNext()) {
            DataHolderBuildConfig config = (DataHolderBuildConfig)associations.get(it.next());
            DataHolder dataHolder = this.createDataHolder(config);
            if (dataHolder == null) continue;
            result.add(dataHolder);
        }
        return result;
    }

    private void getDataHoldersFromElements(FlowElementsContainer container, String resourceId, Map<String, DataHolderBuildConfig> associations) {
        for (FlowElement fe : container.getFlowElements()) {
            if (fe instanceof UserTask && fe.getId().equals(resourceId)) {
                List dataOutputAssociations;
                UserTask utask = (UserTask)fe;
                List dataInputAssociations = utask.getDataInputAssociations();
                if (dataInputAssociations != null) {
                    for (DataInputAssociation inputAssociation : dataInputAssociations) {
                        if (inputAssociation.getSourceRef() == null || inputAssociation.getSourceRef().size() <= 0 || inputAssociation.getTargetRef() == null) continue;
                        String variableId = ((ItemAwareElement)inputAssociation.getSourceRef().get(0)).getId();
                        DataInput input = (DataInput)inputAssociation.getTargetRef();
                        String id = input != null ? input.getName() : null;
                        DataHolderBuildConfig config = variableId != null && id != null ? associations.get(variableId) : null;
                        if (config == null) continue;
                        config.setInputId(id);
                    }
                }
                if ((dataOutputAssociations = utask.getDataOutputAssociations()) == null) continue;
                for (DataOutputAssociation outputAssociation : dataOutputAssociations) {
                    if (outputAssociation.getSourceRef() == null || outputAssociation.getSourceRef().size() <= 0 || outputAssociation.getTargetRef() == null) continue;
                    String variableId = outputAssociation.getTargetRef().getId();
                    DataOutput output = (DataOutput)outputAssociation.getSourceRef().get(0);
                    String outId = output != null ? output.getName() : null;
                    DataHolderBuildConfig config = variableId != null && outId != null ? associations.get(variableId) : null;
                    if (config == null) continue;
                    config.setOutputId(outId);
                }
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.getDataHoldersFromElements((FlowElementsContainer)fe, resourceId, associations);
        }
    }

    private Set<DataHolder> getProcessDataHolders(List<Property> processProperties, String path) {
        TreeSet<DataHolder> result = new TreeSet<DataHolder>();
        String[] colors = this.dataHolderManager.getHolderColors().keySet().toArray(new String[0]);
        int index = 0;
        for (Property prop : processProperties) {
            String propertyName = prop.getId();
            String propertyType = (String)StringUtils.defaultIfEmpty((CharSequence)prop.getItemSubjectRef().getStructureRef(), (CharSequence)"java.lang.Object");
            DataHolderBuildConfig config = new DataHolderBuildConfig(propertyName, "", propertyName, colors[index], propertyType);
            config.addAttribute("path", path);
            DataHolder dataHolder = this.createDataHolder(config);
            if (dataHolder != null) {
                result.add(dataHolder);
            }
            if (index == colors.length - 1) {
                index = 0;
                continue;
            }
            ++index;
        }
        return result;
    }

    private DataHolder createDataHolder(DataHolderBuildConfig config) {
        String type = config.getValue();
        if (this.isBaseType(type)) {
            type = this.normalizeBaseType(type);
        }
        DataHolderBuilder builder = this.dataHolderManager.getBuilderByHolderValueType(type, config.getAttribute("path"));
        config.setValue(type);
        if (builder != null) {
            return builder.buildDataHolder(config);
        }
        return null;
    }

    private boolean isBaseType(String type) {
        return "String".equals(type) || String.class.getName().equals(type) || "Integer".equals(type) || Integer.class.getName().equals(type) || "Short".equals(type) || Short.class.getName().equals(type) || "Long".equals(type) || Long.class.getName().equals(type) || "Float".equals(type) || Float.class.getName().equals(type) || "Double".equals(type) || Double.class.getName().equals(type) || "Boolean".equals(type) || Boolean.class.getName().equals(type) || "Date".equals(type) || Date.class.getName().equals(type) || "BigDecimal".equals(type) || BigDecimal.class.getName().equals(type) || "BigInteger".equals(type) || BigInteger.class.getName().equals(type);
    }

    private String normalizeBaseType(String type) {
        if (type.length() < 10) {
            if ("String".equals(type)) {
                return String.class.getName();
            }
            if ("Integer".equals(type)) {
                return Integer.class.getName();
            }
            if ("Short".equals(type)) {
                return Short.class.getName();
            }
            if ("Long".equals(type)) {
                return Long.class.getName();
            }
            if ("Float".equals(type)) {
                return Float.class.getName();
            }
            if ("Double".equals(type)) {
                return Double.class.getName();
            }
            if ("Boolean".equals(type)) {
                return Boolean.class.getName();
            }
            if ("Date".equals(type)) {
                return Date.class.getName();
            }
            if ("BigDecimal".equals(type)) {
                return BigDecimal.class.getName();
            }
            if ("BigInteger".equals(type)) {
                return BigInteger.class.getName();
            }
        }
        return type;
    }
}

