/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jbpm.formModeler.service.annotation.config.Config;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="localeManager")
public class LocaleManager {
    protected Logger log = LoggerFactory.getLogger(LocaleManager.class);
    @Inject
    @Config(value="en,es,ca,fr,ja,de,pt,zh")
    protected String[] installedLocaleIds;
    @Inject
    @Config(value="en")
    protected String defaultLocaleId;
    private Locale[] availableLocales;
    private Locale currentLocale;
    private Locale currentEditLocale;
    private Locale defaultLocale;

    public static LocaleManager lookup() {
        return (LocaleManager)CDIBeanLocator.getBeanByName("localeManager");
    }

    @PostConstruct
    public void init() {
        ArrayList<Locale> availableLocalesList = new ArrayList<Locale>();
        for (int i = 0; i < this.installedLocaleIds.length; ++i) {
            Locale locale = this.getLocaleById(this.installedLocaleIds[i]);
            if (locale == null) continue;
            availableLocalesList.add(locale);
        }
        this.availableLocales = availableLocalesList.toArray(new Locale[availableLocalesList.size()]);
        this.defaultLocale = this.getLocaleById(this.defaultLocaleId);
    }

    public String[] getInstalledLocaleIds() {
        return this.installedLocaleIds;
    }

    public void setInstalledLocaleIds(String[] installedLocaleIds) {
        this.installedLocaleIds = installedLocaleIds;
    }

    public String getDefaultLocaleId() {
        return this.defaultLocaleId;
    }

    public void setDefaultLocaleId(String defaultLocale) {
        this.defaultLocaleId = defaultLocale;
        this.defaultLocale = this.getLocaleById(defaultLocale);
    }

    public Locale getLocaleById(String localeId) {
        Locale[] allLocales = this.getAllLocales();
        for (int i = 0; i < allLocales.length; ++i) {
            Locale locale = allLocales[i];
            if (!locale.toString().equals(localeId)) continue;
            return locale;
        }
        return null;
    }

    public Locale[] getAllLocales() {
        return Locale.getAvailableLocales();
    }

    public Locale[] getPlatformAvailableLocales() {
        return this.availableLocales;
    }

    public Locale[] geLocales() {
        return this.getPlatformAvailableLocales();
    }

    public Locale getCurrentEditLocale() {
        return this.currentEditLocale == null ? this.defaultLocale : this.currentEditLocale;
    }

    public void setCurrentEditLocale(Locale currentEditLocale) {
        this.currentEditLocale = currentEditLocale;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale == null ? this.defaultLocale : this.currentLocale;
    }

    public void setCurrentLocale(Locale currentLocale) {
        this.currentLocale = currentLocale;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    protected String[] localeToString(Locale[] locales) {
        ArrayList<String> langs = new ArrayList<String>();
        for (int i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            String s = locale.toString();
            langs.add(s);
        }
        return langs.toArray(new String[langs.size()]);
    }

    public String[] getAllLanguages() {
        return this.localeToString(this.getAllLocales());
    }

    public String[] getPlatformAvailableLangs() {
        return this.localeToString(this.getPlatformAvailableLocales());
    }

    public String[] getLangs() {
        return this.getPlatformAvailableLangs();
    }

    public String getCurrentEditLang() {
        return this.getCurrentEditLocale().toString();
    }

    public void setCurrentEditLang(String langId) {
        Locale locale = this.getLocaleById(langId);
        if (locale != null) {
            this.setCurrentEditLocale(locale);
        } else {
            this.log.error("Can't set edit lang to {}", (Object)langId);
        }
    }

    public String getCurrentLang() {
        return this.getCurrentLocale().toString();
    }

    public void setCurrentLang(String langId) {
        Locale locale = this.getLocaleById(langId);
        if (locale != null) {
            this.setCurrentLocale(locale);
        } else {
            this.log.error("Can't set current lang to {}", (Object)langId);
        }
    }

    public String getDefaultLang() {
        return this.getDefaultLocale().toString();
    }

    public Object localize(Map localizedData) {
        if (localizedData == null) {
            return null;
        }
        String lang = this.getCurrentLocale().getLanguage();
        Object data = localizedData.get(lang);
        if (!(data == null || data instanceof String && "".equals(data))) {
            return data;
        }
        Locale locale = this.getCurrentLocale();
        data = localizedData.get(locale);
        if (!(null == data || data instanceof String && "".equals(data))) {
            return data;
        }
        data = localizedData.get(this.getDefaultLang());
        if (!(null == data || data instanceof String && "".equals(data))) {
            return data;
        }
        return localizedData.get(this.getDefaultLocale());
    }

    public static Locale currentLocale() {
        return LocaleManager.lookup().getCurrentLocale();
    }

    public static String currentLang() {
        return LocaleManager.lookup().getCurrentLang();
    }
}

