/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.comparator;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.service.LocaleManager;
import org.jbpm.formModeler.service.comparator.ComparatorByCriteria;

public abstract class AbstractComparatorByCriteria
implements ComparatorByCriteria {
    private static transient Log log = LogFactory.getLog((String)AbstractComparatorByCriteria.class.getName());
    protected ArrayList sortCriterias = new ArrayList();
    protected Locale locale = LocaleManager.currentLocale();

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void addSortCriteria(String criteriaId, int order) {
        Object[] criteriaProps = this.getSortCriteria(criteriaId);
        if (criteriaProps == null) {
            criteriaProps = new Object[]{criteriaId, new Integer(order)};
        }
        this.sortCriterias.remove(criteriaProps);
        this.sortCriterias.add(criteriaProps);
    }

    @Override
    public void removeSortCriteria(String criteriaId) {
        Object[] criteriaProps = this.getSortCriteria(criteriaId);
        if (criteriaProps != null) {
            this.sortCriterias.remove(criteriaProps);
        }
    }

    @Override
    public void removeAllSortCriteria() {
        this.sortCriterias.clear();
    }

    @Override
    public int getSortCriteriaPriority(String criteriaId) {
        Object[] criteriaProps = this.getSortCriteria(criteriaId);
        if (criteriaProps != null) {
            return this.sortCriterias.indexOf(criteriaProps) + 1;
        }
        return 0;
    }

    @Override
    public int getSortCriteriaOrdering(String criteriaId) {
        return (Integer)this.getSortCriteria(criteriaId)[1];
    }

    @Override
    public String[] getCriteriaIds() {
        String[] ids = new String[this.sortCriterias.size()];
        for (int i = 0; i < ids.length; ++i) {
            Object[] criteriaProps = (Object[])this.sortCriterias.get(i);
            ids[i] = (String)criteriaProps[0];
        }
        return ids;
    }

    protected Object[] getSortCriteria(String criteriaId) {
        for (Object[] criteriaProps : this.sortCriterias) {
            if (!criteriaProps[0].equals(criteriaId)) continue;
            return criteriaProps;
        }
        return null;
    }

    @Override
    public boolean existCriteria(String criteriaId) {
        for (int i = 0; i < this.getCriteriaIds().length; ++i) {
            String criteria = this.getCriteriaIds()[i];
            if (!criteria.equals(criteriaId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            AbstractComparatorByCriteria other = (AbstractComparatorByCriteria)obj;
            if (this.sortCriterias.size() != other.sortCriterias.size()) {
                return false;
            }
            for (int i = 0; i < this.sortCriterias.size(); ++i) {
                Object[] criteriaProps = (Object[])this.sortCriterias.get(i);
                Object[] otherCriteriaProps = (Object[])other.sortCriterias.get(i);
                String thisCriteriaId = (String)criteriaProps[0];
                Integer thisOrder = (Integer)criteriaProps[1];
                String otherCriteriaId = (String)otherCriteriaProps[0];
                Integer otherOrder = (Integer)otherCriteriaProps[1];
                if (otherCriteriaId.equals(thisCriteriaId) && thisOrder.intValue() == otherOrder.intValue()) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public abstract int compare(Object var1, Object var2);
}

