/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.error;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.jbpm.formModeler.service.annotation.config.Config;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;
import org.jbpm.formModeler.service.error.ApplicationError;
import org.jbpm.formModeler.service.error.BusinessError;
import org.jbpm.formModeler.service.error.ErrorReport;
import org.jbpm.formModeler.service.error.TechnicalError;

@ApplicationScoped
public class ErrorManager {
    @Inject
    protected Log log;
    @Inject
    @Config(value="true")
    protected boolean logErrorReportEnabled;
    @Inject
    @Config(value="true")
    protected boolean logDBInterlockThreadsEnabled;
    protected ThreadLocal<ErrorReport> currentThreadError = new ThreadLocal();

    public static ErrorManager lookup() {
        return (ErrorManager)CDIBeanLocator.getBeanByType(ErrorManager.class);
    }

    public boolean isLogErrorReportEnabled() {
        return this.logErrorReportEnabled;
    }

    public void setLogErrorReportEnabled(boolean logErrorReportEnabled) {
        this.logErrorReportEnabled = logErrorReportEnabled;
    }

    public void throwTechnicalError(String message, Throwable cause) {
        throw new TechnicalError(message, cause);
    }

    public void throwBusinessError(String title, String message) {
        throw new BusinessError(0, title, message);
    }

    public void throwBusinessWarning(String title, String message) {
        throw new BusinessError(1, title, message);
    }

    public void throwBusinessInfo(String title, String message) {
        throw new BusinessError(2, title, message);
    }

    public ApplicationError getApplicationErrorCause(Throwable e) {
        LinkedList<ApplicationError> appErrors = new LinkedList<ApplicationError>();
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ApplicationError)) continue;
            appErrors.add((ApplicationError)cause);
        }
        if (appErrors.isEmpty()) {
            return null;
        }
        return (ApplicationError)appErrors.getLast();
    }

    public Throwable getRootCause(Throwable t) {
        if (t == null) {
            return null;
        }
        Throwable root = t.getCause();
        if (root == null) {
            if (t instanceof ServletException) {
                root = ((ServletException)t).getRootCause();
            }
            if (t instanceof JspException) {
                root = ((JspException)t).getRootCause();
            }
            if (t instanceof InvocationTargetException) {
                root = ((InvocationTargetException)t).getTargetException();
            }
        }
        if (root == null) {
            return t;
        }
        return this.getRootCause(root);
    }

    public ErrorReport notifyError(Throwable t, boolean doLog) {
        ErrorReport report = new ErrorReport();
        report.setId(String.valueOf(System.currentTimeMillis()));
        report.setException(t);
        this.currentThreadError.set(report);
        if (doLog) {
            this.logError(report);
        }
        return report;
    }

    public void logError(ErrorReport report) {
        ApplicationError appError = this.getApplicationErrorCause(report.getException());
        if (appError == null && this.logErrorReportEnabled) {
            this.log.error((Object)("UNEXPECTED ERROR.\n" + report.printContext(0)));
        }
    }

    public ErrorReport getErrorReport() {
        return this.currentThreadError.get();
    }
}

