/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.annotation.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.service.annotation.config.Config;

@ApplicationScoped
public class ConfigReader {
    private volatile Properties globalProperties;
    private volatile Map<String, Properties> beanPropertyMap;
    public static final String beansConfigFile = "META-INF/beans.config";

    @PostConstruct
    public void init() {
        try {
            this.globalProperties = new Properties();
            this.beanPropertyMap = new HashMap<String, Properties>();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(beansConfigFile);
            if (is != null) {
                this.globalProperties.load(is);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Produces
    @Config
    public String readConfig(InjectionPoint p) {
        String configKey;
        String configValue;
        String beanKey = p.getMember().getDeclaringClass().getName();
        Properties beanProperties = this.beanPropertyMap.get(beanKey);
        if (beanProperties == null) {
            beanProperties = new Properties();
            this.beanPropertyMap.put(beanKey, beanProperties);
            try {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/" + beanKey + ".config");
                if (is != null) {
                    beanProperties.load(is);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if ((configValue = beanProperties.getProperty(configKey = p.getMember().getName())) != null) {
            return configValue;
        }
        for (Type type : p.getBean().getTypes()) {
            configKey = ((Class)type).getName() + "." + p.getMember().getName();
            configValue = this.globalProperties.getProperty(configKey);
            if (configValue == null) continue;
            return configValue;
        }
        configKey = p.getMember().getName();
        configValue = this.globalProperties.getProperty(configKey);
        if (configValue != null) {
            return configValue;
        }
        Annotated annotated = p.getAnnotated();
        Config config = (Config)annotated.getAnnotation(Config.class);
        if (config != null) {
            return config.value();
        }
        return null;
    }

    @Produces
    @Config
    public int readPrimitiveInt(InjectionPoint p) {
        String val = this.readConfig(p);
        return Integer.parseInt(val);
    }

    @Produces
    @Config
    public long readPrimitiveLong(InjectionPoint p) {
        String val = this.readConfig(p);
        return Long.parseLong(val);
    }

    @Produces
    @Config
    public float readPrimitiveFloat(InjectionPoint p) {
        String val = this.readConfig(p);
        return Float.parseFloat(val);
    }

    @Produces
    @Config
    public boolean readPrimitiveBoolean(InjectionPoint p) {
        String val = this.readConfig(p);
        return Boolean.parseBoolean(val);
    }

    @Produces
    @Config
    public double readPrimitiveDouble(InjectionPoint p) {
        String val = this.readConfig(p);
        return Double.parseDouble(val);
    }

    @Produces
    @Config
    public String[] readStringArray(InjectionPoint p) {
        String val = this.readConfig(p);
        String[] result = StringUtils.split((String)val, (String)",");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    @Produces
    @Config
    public Map<String, String> readStringMap(InjectionPoint p) {
        String val = this.readConfig(p);
        HashMap<String, String> results = new HashMap<String, String>();
        String[] rows = StringUtils.split((String)val, (String)",");
        for (int i = 0; i < rows.length; ++i) {
            String row = rows[i].trim();
            String[] rowSplit = row.split("=");
            if (rowSplit.length != 2) {
                throw new IllegalArgumentException("Illegal map entry '" + row + "'");
            }
            results.put(rowSplit[0].trim(), rowSplit[1].trim());
        }
        return results;
    }

    @Produces
    @Config
    public Properties readProperties(InjectionPoint p) {
        String val = this.readConfig(p);
        Properties results = new Properties();
        String[] rows = StringUtils.split((String)val, (String)",");
        for (int i = 0; i < rows.length; ++i) {
            String row = rows[i].trim();
            String[] rowSplit = row.split("=");
            if (rowSplit.length != 2) {
                throw new IllegalArgumentException("Illegal property entry '" + row + "'");
            }
            results.put(rowSplit[0].trim(), rowSplit[1].trim());
        }
        return results;
    }
}

