/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.panels.modeler.backend;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.Project;
import org.jbpm.formModeler.api.client.FormEditorContext;
import org.jbpm.formModeler.api.client.FormEditorContextManager;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.config.FormSerializationManager;
import org.jbpm.formModeler.core.rendering.FormFinder;
import org.kie.workbench.common.services.datamodeller.util.FileUtils;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

public class EditionFormFinder
implements FormFinder {
    public static final String MAIN_RESOURCES_PATH = "src/main/resources";
    private Logger log = LoggerFactory.getLogger(EditionFormFinder.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private KieProjectService projectService;
    @Inject
    private FormSerializationManager formSerializationManager;
    @Inject
    private FormEditorContextManager formEditorContextManager;

    public Form getForm(String ctxUID) {
        FormEditorContext context = this.formEditorContextManager.getRootEditorContext(ctxUID);
        if (context != null) {
            return context.getForm();
        }
        return null;
    }

    public Form getFormByPath(String ctxUID, String formPath) {
        FormEditorContext editorContext = this.formEditorContextManager.getRootEditorContext(ctxUID);
        if (editorContext != null) {
            try {
                org.uberfire.backend.vfs.Path currentForm = Paths.convert((Path)this.ioService.get(new URI(editorContext.getPath())));
                Path path = Paths.convert((org.uberfire.backend.vfs.Path)currentForm).getParent().resolve(formPath);
                String xml = this.ioService.readAllString(path).trim();
                return this.formSerializationManager.loadFormFromXML(xml, path.toUri().toString());
            }
            catch (Exception e) {
                this.log.warn("Error getting form {} from context {}: {}", new Object[]{formPath, ctxUID, e});
            }
        }
        return null;
    }

    public Form getFormById(String ctxUID, long formId) {
        FormEditorContext editorContext = this.formEditorContextManager.getRootEditorContext(ctxUID);
        if (editorContext != null) {
            try {
                if (editorContext.getForm().getId().equals(new Long(formId))) {
                    return editorContext.getForm();
                }
                org.uberfire.backend.vfs.Path currentForm = Paths.convert((Path)this.ioService.get(new URI(editorContext.getPath())));
                Project project = this.projectService.resolveProject(currentForm);
                FileUtils utils = FileUtils.getInstance();
                ArrayList<Path> nioPaths = new ArrayList<Path>();
                nioPaths.add(Paths.convert((org.uberfire.backend.vfs.Path)project.getRootPath()));
                Collection forms = utils.scan(this.ioService, nioPaths, "form", true);
                String header = this.formSerializationManager.generateHeaderFormFormId(formId);
                for (FileUtils.ScanResult form : forms) {
                    Path formPath = form.getFile();
                    Path path = Paths.convert((org.uberfire.backend.vfs.Path)project.getRootPath()).resolve(MAIN_RESOURCES_PATH).resolve(formPath);
                    String xml = this.ioService.readAllString(path).trim();
                    if (!xml.startsWith(header)) continue;
                    return this.formSerializationManager.loadFormFromXML(xml);
                }
            }
            catch (Exception e) {
                this.log.warn("Error getting form {} from context {}: {}", new Object[]{formId, ctxUID, e});
            }
        }
        return null;
    }

    public int getPriority() {
        return 0;
    }
}

