/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.editor.client.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.exceptions.GenericPortableException;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.formModeler.editor.client.handlers.NewFormDefinitionHandler;
import org.jbpm.formModeler.editor.service.FormModelerService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewFormDefinitionHandlerTest {
    NewFormDefinitionHandler testedHandler;
    @Mock
    EventSourceMock<NewResourceSuccessEvent> newResourceSuccessEventMock;
    @Mock
    FormModelerService fmServiceMock;
    @Mock
    PlaceManager pManagerMock;
    @Mock
    EventSourceMock<NotificationEvent> eventMock;
    @Mock
    NewResourcePresenter nrpresenterMock;
    @Mock
    ErrorPopupPresenter errorPopupMock;
    @Mock
    Package packageMock;

    @Before
    public void setupMocks() {
        CallerMock fmServiceCaller = new CallerMock((Object)this.fmServiceMock);
        this.testedHandler = (NewFormDefinitionHandler)Mockito.spy((Object)new NewFormDefinitionHandler((Caller)fmServiceCaller, this.pManagerMock, null, (Event)this.eventMock, this.errorPopupMock){
            {
                this.newResourceSuccessEvent = NewFormDefinitionHandlerTest.this.newResourceSuccessEventMock;
            }

            protected String buildFileName(String baseFileName, ResourceTypeDefinition resourceType) {
                return "not relevant for this test";
            }

            protected void notifySuccess() {
            }
        });
    }

    @Test
    public void errorPopupDisplayedWhenFormAlreadyExists() {
        Mockito.when((Object)this.fmServiceMock.createForm((Path)Matchers.any(Path.class), Matchers.anyString())).thenThrow(new Throwable[]{new GenericPortableException("File already exists.")});
        this.testedHandler.create(this.packageMock, "existingForm", this.nrpresenterMock);
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupMock)).showMessage(CommonConstants.INSTANCE.SorryAnItemOfThatNameAlreadyExistsInTheRepositoryPleaseChooseAnother());
    }

    @Test
    public void createTest() {
        NewResourcePresenter presenter = (NewResourcePresenter)Mockito.mock(NewResourcePresenter.class);
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PathPlaceRequest pathPlaceRequest = (PathPlaceRequest)Mockito.mock(PathPlaceRequest.class);
        ((FormModelerService)Mockito.doReturn((Object)path).when((Object)this.fmServiceMock)).createForm((Path)Matchers.any(Path.class), Matchers.anyString());
        ((PathPlaceRequest)Mockito.doReturn((Object)path).when((Object)pathPlaceRequest)).getPath();
        ((NewFormDefinitionHandler)Mockito.doReturn((Object)pathPlaceRequest).when((Object)this.testedHandler)).createPathPlaceRequest((Path)path);
        this.testedHandler.create((Package)Mockito.mock(Package.class), "", presenter);
        ((NewResourcePresenter)Mockito.verify((Object)presenter)).complete();
        ((EventSourceMock)Mockito.verify(this.newResourceSuccessEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(NewResourceSuccessEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.pManagerMock, (VerificationMode)Mockito.times((int)1))).goTo((PlaceRequest)pathPlaceRequest);
    }
}

