/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.editor.client.editors;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jbpm.formModeler.editor.client.editors.FormModelerPanelPresenter;
import org.jbpm.formModeler.editor.client.editors.FormModelerPanelView;
import org.jbpm.formModeler.editor.client.type.FormDefinitionResourceType;
import org.jbpm.formModeler.editor.model.FormEditorContextTO;
import org.jbpm.formModeler.editor.model.FormModelerContent;
import org.jbpm.formModeler.editor.service.FormModelerService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilderImpl;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class FormModelerPanelPresenterTest {
    @Mock
    protected FormModelerPanelView view;
    @Mock
    protected FormModelerService modelerServiceMock;
    @Mock
    protected MetadataService metadataServiceMock;
    @Mock
    protected EventSourceMock<NotificationEvent> notificationMock;
    @Mock
    protected EventSourceMock<ChangeTitleWidgetEvent> changeTitleNotificationMock;
    @GwtMock
    protected FormDefinitionResourceType formDefinitionResourceTypeMock;
    @Mock
    protected PlaceRequest placeRequestMock;
    @GwtMock
    protected VersionRecordManager versionRecordManagerMock;
    @Mock
    protected Overview overview;
    @Mock
    protected ObservablePath path;
    @Mock
    protected BasicFileMenuBuilder menuBuilder;
    @Spy
    @InjectMocks
    protected FileMenuBuilderImpl fileMenuBuilder;
    @Mock
    protected ProjectController projectController;
    @Mock
    protected ProjectContext workbenchContext;
    protected FormEditorContextTO editionContextTO = new FormEditorContextTO("contextId");
    protected FormModelerPanelPresenter presenter;

    @Before
    public void setup() {
        this.presenter = new FormModelerPanelPresenter(this.view){
            {
                this.placeManager = (PlaceManager)Mockito.mock(PlaceManager.class);
                this.modelerService = new CallerMock((Object)FormModelerPanelPresenterTest.this.modelerServiceMock);
                this.busyIndicatorView = (BusyIndicatorView)Mockito.mock(BusyIndicatorView.class);
                this.notification = FormModelerPanelPresenterTest.this.notificationMock;
                this.changeTitleNotification = FormModelerPanelPresenterTest.this.changeTitleNotificationMock;
                this.metadataService = new CallerMock((Object)FormModelerPanelPresenterTest.this.metadataServiceMock);
                this.resourceType = FormModelerPanelPresenterTest.this.formDefinitionResourceTypeMock;
                this.fileNameValidator = (DefaultFileNameValidator)Mockito.mock(DefaultFileNameValidator.class);
                this.fileMenuBuilder = (FileMenuBuilder)Mockito.mock(FileMenuBuilder.class);
                this.versionRecordManager = FormModelerPanelPresenterTest.this.versionRecordManagerMock;
                this.kieView = (KieEditorWrapperView)Mockito.mock(KieEditorWrapperView.class);
                this.overviewWidget = (OverviewWidgetPresenter)Mockito.mock(OverviewWidgetPresenter.class);
                this.savePopUpPresenter = (SavePopUpPresenter)Mockito.mock(SavePopUpPresenter.class);
                this.fileMenuBuilder = FormModelerPanelPresenterTest.this.fileMenuBuilder;
                this.projectController = FormModelerPanelPresenterTest.this.projectController;
                this.workbenchContext = FormModelerPanelPresenterTest.this.workbenchContext;
            }
        };
        Mockito.when((Object)this.versionRecordManagerMock.getCurrentPath()).thenReturn((Object)this.path);
        FormModelerContent content = this.createContent();
        Mockito.when((Object)this.modelerServiceMock.loadContent((Path)this.path)).thenReturn((Object)content);
        Mockito.when((Object)this.modelerServiceMock.reloadContent((Path)this.path, content.getContextTO().getCtxUID())).thenReturn((Object)this.editionContextTO);
        this.presenter.onStartup(this.path, this.placeRequestMock);
    }

    @After
    public void finishTest() {
        this.presenter.onClose();
    }

    @Test
    public void testSaveForm() {
        String commitMessage = "commit message";
        this.presenter.save();
        this.presenter.runSaveCommand(commitMessage);
        ((FormModelerService)Mockito.verify((Object)this.modelerServiceMock, (VerificationMode)Mockito.times((int)1))).save((Path)Mockito.eq((Object)this.path), Mockito.eq((Object)this.editionContextTO), (Metadata)Mockito.any(Metadata.class), (String)Mockito.eq((Object)commitMessage));
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManagerMock, (VerificationMode)Mockito.atLeast((int)1))).reloadVersions((Path)this.path);
    }

    @Test
    public void testReloadForm() {
        this.presenter.reload();
        ((FormModelerService)Mockito.verify((Object)this.modelerServiceMock, (VerificationMode)Mockito.times((int)1))).reloadContent((Path)this.path, this.editionContextTO.getCtxUID());
    }

    @Test
    public void testMakeMenuBar() {
        Mockito.reset((Object[])new FileMenuBuilderImpl[]{this.fileMenuBuilder});
        ((ProjectContext)Mockito.doReturn((Object)Mockito.mock(Project.class)).when((Object)this.workbenchContext)).getActiveProject();
        ((ProjectController)Mockito.doReturn((Object)true).when((Object)this.projectController)).canUpdateProject((Project)Mockito.any());
        this.presenter.makeMenuBar();
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addSave((MenuItem)Mockito.any(MenuItem.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addCopy((Path)Mockito.any(Path.class), (Validator)Mockito.any(DefaultFileNameValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addRename((Path)Mockito.any(Path.class), (Validator)Mockito.any(DefaultFileNameValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addDelete((Path)Mockito.any(Path.class));
    }

    @Test
    public void testMakeMenuBarWithoutUpdateProjectPermission() {
        Mockito.reset((Object[])new FileMenuBuilderImpl[]{this.fileMenuBuilder});
        ((ProjectContext)Mockito.doReturn((Object)Mockito.mock(Project.class)).when((Object)this.workbenchContext)).getActiveProject();
        ((ProjectController)Mockito.doReturn((Object)false).when((Object)this.projectController)).canUpdateProject((Project)Mockito.any());
        this.presenter.makeMenuBar();
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addSave((MenuItem)Mockito.any(MenuItem.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addCopy((Path)Mockito.any(Path.class), (Validator)Mockito.any(DefaultFileNameValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addRename((Path)Mockito.any(Path.class), (Validator)Mockito.any(DefaultFileNameValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addDelete((Path)Mockito.any(Path.class));
    }

    protected FormModelerContent createContent() {
        FormModelerContent content = new FormModelerContent();
        content.setPath((Path)this.path);
        content.setOverview(this.overview);
        content.setContextTO(this.editionContextTO);
        return content;
    }
}

