/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.kie.services.form.finder;

import java.util.Map;
import javax.inject.Inject;
import org.jbpm.formModeler.api.client.FormRenderContext;
import org.jbpm.formModeler.api.client.FormRenderContextManager;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.config.FormSerializationManager;
import org.jbpm.formModeler.core.rendering.FormFinder;
import org.jbpm.kie.services.impl.FormManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeFormFinder
implements FormFinder {
    private Logger log = LoggerFactory.getLogger(RuntimeFormFinder.class);
    @Inject
    private FormRenderContextManager formRenderContextManager;
    @Inject
    private FormSerializationManager formSerializationManager;
    @Inject
    private FormManagerService formManagerService;

    public Form getForm(String ctxUID) {
        FormRenderContext renderContext = this.formRenderContextManager.getRootContext(ctxUID);
        if (renderContext != null) {
            return renderContext.getForm();
        }
        return null;
    }

    public Form getFormByPath(String ctxUID, String formPath) {
        FormRenderContext renderContext = this.formRenderContextManager.getRootContext(ctxUID);
        if (renderContext != null) {
            try {
                String form = this.formManagerService.getFormByKey(renderContext.getDeploymentId(), formPath);
                if (form == null) {
                    form = renderContext.getContextForms().get(formPath);
                }
                if (form != null) {
                    if (form instanceof Form) {
                        return (Form)form;
                    }
                    if (form instanceof String) {
                        Form result = this.formSerializationManager.loadFormFromXML(form);
                        renderContext.getContextForms().put(formPath, result);
                        return result;
                    }
                }
            }
            catch (Exception e) {
                this.log.warn("Error getting form {} from context {}: {}", new Object[]{formPath, ctxUID, e});
            }
        }
        return null;
    }

    public Form getFormById(String ctxUID, long formId) {
        FormRenderContext renderContext = this.formRenderContextManager.getRootContext(ctxUID);
        if (renderContext != null) {
            try {
                if (renderContext.getForm().getId().equals(new Long(formId))) {
                    return renderContext.getForm();
                }
                Map forms = this.formManagerService.getAllFormsByDeployment(renderContext.getDeploymentId());
                if (forms == null) {
                    forms = renderContext.getContextForms();
                }
                String header = this.formSerializationManager.generateHeaderFormFormId(formId);
                for (String key : forms.keySet()) {
                    Object form = forms.get(key);
                    if (form instanceof Form) {
                        if (!((Form)form).getId().equals(formId)) continue;
                        return (Form)form;
                    }
                    if (!(form instanceof String) || !form.toString().trim().startsWith(header)) continue;
                    Form result = this.formSerializationManager.loadFormFromXML((String)form);
                    renderContext.getContextForms().put(key, result);
                    return result;
                }
            }
            catch (Exception e) {
                this.log.warn("Error getting form {} from context {}: {}", new Object[]{formId, ctxUID, e});
            }
        }
        return null;
    }

    public int getPriority() {
        return 1;
    }
}

