/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.kie.services.form.provider;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jbpm.formModeler.api.client.FormRenderContext;
import org.jbpm.formModeler.api.client.FormRenderContextManager;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.config.FormSerializationManager;
import org.jbpm.formModeler.kie.services.FormRenderContentMarshallerManager;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.kie.services.impl.form.provider.AbstractFormProvider;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormModelerFormProvider
extends AbstractFormProvider {
    protected Logger log = LoggerFactory.getLogger(FormModelerFormProvider.class);
    @Inject
    private RuntimeDataService dataService;
    @Inject
    private FormSerializationManager formSerializationManager;
    @Inject
    private FormRenderContextManager formRenderContextManager;
    @Inject
    private FormRenderContentMarshallerManager formRenderContentMarshaller;
    private String formExtension = ".form";

    @Inject
    public void setFormManagerService(FormManagerService formManagerService) {
        super.setFormManagerService(formManagerService);
    }

    public int getPriority() {
        return 2;
    }

    public String render(String name, ProcessDefinition process, Map<String, Object> renderContext) {
        String templateString = this.formManagerService.getFormByKey(process.getDeploymentId(), process.getId() + this.getFormSuffix());
        if (templateString == null || templateString.isEmpty()) {
            return null;
        }
        return this.renderProcessForm(process, new ByteArrayInputStream(templateString.getBytes()), renderContext);
    }

    public String render(String name, Task task, ProcessDefinition process, Map<String, Object> renderContext) {
        if (task == null) {
            return null;
        }
        String lookupName = this.getTaskFormName(task);
        if (lookupName == null || lookupName.isEmpty() || !lookupName.endsWith(this.formExtension)) {
            return null;
        }
        String templateString = this.formManagerService.getFormByKey(task.getTaskData().getDeploymentId(), lookupName);
        if (templateString != null && !templateString.isEmpty()) {
            return this.renderTaskForm(task, new ByteArrayInputStream(templateString.getBytes()), renderContext);
        }
        return null;
    }

    protected String renderTaskForm(Task task, InputStream template, Map<String, Object> renderContext) {
        String result = null;
        try {
            Form form = this.formSerializationManager.loadFormFromXML(template);
            HashMap<String, Task> inputs = new HashMap<String, Task>();
            Map outputs = task.getTaskData().getOutputContentId() == -1L ? new HashMap() : (Map)renderContext.get("outputs");
            Map m = (Map)renderContext.get("inputs");
            if (m != null) {
                inputs.putAll(m);
            }
            inputs.put("task", task);
            FormRenderContext context = this.formRenderContextManager.newContext(form, task.getTaskData().getDeploymentId(), inputs, outputs);
            this.formRenderContentMarshaller.addContentMarshaller(context.getUID(), (ContentMarshallerContext)renderContext.get("marshallerContext"));
            String status = task.getTaskData().getStatus().name();
            boolean readonly = !"InProgress".equals(status);
            context.setReadonly(readonly);
            result = context.getUID();
        }
        catch (Exception e) {
            this.log.warn("Error rendering form: ", (Throwable)e);
        }
        return result;
    }

    protected String renderProcessForm(ProcessDefinition process, InputStream template, Map<String, Object> renderContext) {
        String result = null;
        try {
            Form form = this.formSerializationManager.loadFormFromXML(template);
            HashMap<String, ProcessDefinition> ctx = new HashMap<String, ProcessDefinition>();
            ctx.put("process", process);
            FormRenderContext context = this.formRenderContextManager.newContext(form, process.getDeploymentId(), ctx, new HashMap());
            this.formRenderContentMarshaller.addContentMarshaller(context.getUID(), (ContentMarshallerContext)renderContext.get("marshallerContext"));
            result = context.getUID();
        }
        catch (Exception e) {
            this.log.warn("Error rendering form: ", (Throwable)e);
        }
        return result;
    }

    protected String getFormExtension() {
        return this.formExtension;
    }
}

