/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.renderer.includer;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.formModeler.api.client.FormRenderContextTO;
import org.jbpm.formModeler.api.events.FormSubmitFailEvent;
import org.jbpm.formModeler.api.events.FormSubmittedEvent;
import org.jbpm.formModeler.renderer.service.FormRendererIncluderService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@WorkbenchScreen(identifier="FormRendererIncluderPanel")
public class FormRendererPanelIncluderPresenter {
    private FormRenderContextTO context;
    @Inject
    private FormRendererIncluderPanelView view;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    Caller<FormRendererIncluderService> includerService;

    @PostConstruct
    public void init() {
    }

    public void startTest() {
        ((FormRendererIncluderService)this.includerService.call((RemoteCallback)new RemoteCallback<FormRenderContextTO>(){

            public void callback(FormRenderContextTO ctx) {
                FormRendererPanelIncluderPresenter.this.context = ctx;
                FormRendererPanelIncluderPresenter.this.view.loadContext(ctx);
            }
        })).launchTest();
    }

    public void persistForm() {
        ((FormRendererIncluderService)this.includerService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean result) {
                if (result.booleanValue()) {
                    FormRendererPanelIncluderPresenter.this.notification.fire((Object)new NotificationEvent("Form persisted OK!", NotificationEvent.NotificationType.SUCCESS));
                } else {
                    FormRendererPanelIncluderPresenter.this.notification.fire((Object)new NotificationEvent("Something wrong happened persisting form", NotificationEvent.NotificationType.ERROR));
                }
            }
        })).persistContext(this.context.getCtxUID());
    }

    public void clearFormStatus() {
        ((FormRendererIncluderService)this.includerService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean result) {
                if (result.booleanValue()) {
                    FormRendererPanelIncluderPresenter.this.notification.fire((Object)new NotificationEvent("Form cleared!", NotificationEvent.NotificationType.SUCCESS));
                    FormRendererPanelIncluderPresenter.this.view.hide();
                } else {
                    FormRendererPanelIncluderPresenter.this.notification.fire((Object)new NotificationEvent("Something wrong happened clearing form", NotificationEvent.NotificationType.ERROR));
                }
            }
        })).clearContext(this.context.getCtxUID());
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Form Renderer Panel Includer";
    }

    @WorkbenchPartView
    public UberView<FormRendererPanelIncluderPresenter> getView() {
        return this.view;
    }

    public void notifyErrors(int errorNumber) {
        this.notification.fire((Object)new NotificationEvent("Unable to process form, it has " + errorNumber + " errors!", NotificationEvent.NotificationType.WARNING));
    }

    public void notifyFormSubmit() {
        this.notification.fire((Object)new NotificationEvent("Form submitted OK!", NotificationEvent.NotificationType.SUCCESS));
    }

    public void notifyFormProcessingError(String cause) {
        this.notification.fire((Object)new NotificationEvent("Something wrong happened processing form, cause: '" + cause + "'", NotificationEvent.NotificationType.ERROR));
    }

    public void onFormSubmitted(@Observes FormSubmittedEvent event) {
        if (event.isMine(this.context)) {
            int errors = event.getContext().getErrors();
            if (errors == 0) {
                this.notifyFormSubmit();
            } else {
                this.notifyErrors(errors);
            }
        }
    }

    public void onFormSubmitFail(@Observes FormSubmitFailEvent event) {
        if (event.isMine(this.context)) {
            this.notifyFormProcessingError(event.getCause());
        }
    }

    public static interface FormRendererIncluderPanelView
    extends UberView<FormRendererPanelIncluderPresenter> {
        public void loadContext(FormRenderContextTO var1);

        public void hide();
    }
}

