/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.components;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.RedirectToURLResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.ShowScreenResponse;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

@ApplicationScoped
public class ControllerStatus {
    @Inject
    private Log log;
    private CommandResponse response;
    private Throwable exception;
    private String showPage = "/formModeler/controllerResponse.jsp";
    private String currentComponentPage;
    private String requestURI;
    private StringBuffer consumedRequestURI;
    private CommandRequest request;

    public static ControllerStatus lookup() {
        return (ControllerStatus)CDIBeanLocator.getBeanByType(ControllerStatus.class);
    }

    @PostConstruct
    public void init() throws Exception {
        this.response = new ShowScreenResponse(this.showPage);
    }

    public String getShowPage() {
        return this.showPage;
    }

    public void setShowPage(String showPage) {
        this.showPage = showPage;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Throwable getException() {
        return this.exception;
    }

    public CommandResponse getResponse() {
        return this.response;
    }

    public void setResponse(CommandResponse response) {
        if (response == null) {
            response = new ShowScreenResponse(this.showPage);
        }
        this.response = response;
    }

    protected StringBuffer getConsumedRequestURI() {
        return this.consumedRequestURI;
    }

    public void setURIToBeConsumed(String requestURI) {
        this.requestURI = StringUtils.replace((String)requestURI, (String)"//", (String)"/");
        this.consumedRequestURI = new StringBuffer();
    }

    public String getURIToBeConsumed() {
        return this.requestURI;
    }

    public void consumeURIPart(String uriPart) {
        this.consumedRequestURI.append(uriPart);
    }

    public void compareConsumedUri() {
        String consumedUri = StringUtils.replace((String)this.consumedRequestURI.toString(), (String)"//", (String)"/");
        if (consumedUri.endsWith("/")) {
            consumedUri = consumedUri.substring(0, consumedUri.length() - 1);
        }
        if (!this.requestURI.equals(consumedUri)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Received URI: " + this.requestURI));
                this.log.debug((Object)("Consumed URI: " + consumedUri));
            }
            if (StringUtils.isEmpty((String)consumedUri)) {
                this.log.error((Object)("No part of the received uri " + this.requestURI + " has been consumed. Trying to serve it as good as possible."));
            } else if (this.requestURI.startsWith(consumedUri)) {
                String uriToForward;
                this.setResponse(new RedirectToURLResponse(uriToForward, !(uriToForward = this.requestURI.substring(consumedUri.length())).startsWith(this.request.getRequestObject().getContextPath())));
                this.log.warn((Object)("Redirecting to static uri: " + uriToForward));
            } else {
                this.log.error((Object)("Consumed uri " + consumedUri + " is not even part of request uri: " + this.requestURI + ". Trying to serve it as good as possible."));
            }
        }
    }

    public void setRequest(CommandRequest commandRequest) {
        this.request = commandRequest;
        this.setURIToBeConsumed(this.request.getRequestObject().getRequestURI().substring(this.request.getRequestObject().getContextPath().length()));
    }

    public CommandRequest getRequest() {
        return this.request;
    }

    public String getCurrentComponentPage() {
        return this.currentComponentPage;
    }

    public void setCurrentComponentPage(String currentComponentPage) {
        this.currentComponentPage = currentComponentPage;
    }
}

