/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.components;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.jbpm.formModeler.service.bb.mvc.components.handling.BeanHandler;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

@ApplicationScoped
public class HandlerMarkupGenerator {
    @Inject
    private Log log;

    public static HandlerMarkupGenerator lookup() {
        return (HandlerMarkupGenerator)CDIBeanLocator.getBeanByType(HandlerMarkupGenerator.class);
    }

    public String getMarkup(String bean, String property) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getHiddenMarkup("_fb", bean));
        sb.append(this.getHiddenMarkup("_fp", property));
        try {
            BeanHandler element = (BeanHandler)CDIBeanLocator.getBeanByNameOrType((String)bean);
            element.setEnabledForActionHandling(true);
        }
        catch (ClassCastException cce) {
            this.log.error((Object)("Bean " + bean + " is not a BeanHandler."));
        }
        return sb.toString();
    }

    protected String getHiddenMarkup(String name, String value) {
        name = StringEscapeUtils.escapeHtml((String)name);
        value = StringEscapeUtils.escapeHtml((String)value);
        return "<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\">";
    }
}

