/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.components;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.jbpm.formModeler.service.bb.mvc.components.handling.BeanHandler;
import org.jbpm.formModeler.service.bb.mvc.controller.HTTPSettings;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

@ApplicationScoped
public class URLMarkupGenerator {
    @Inject
    private Log log;
    private String handler = "factory";
    private String action = "set";
    public static final String COMMAND_RUNNER = "Controller";

    public static URLMarkupGenerator lookup() {
        return (URLMarkupGenerator)CDIBeanLocator.getBeanByType(URLMarkupGenerator.class);
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getPermanentLink(String bean, String action, Map params) {
        try {
            StringBuffer sb = new StringBuffer();
            String base = COMMAND_RUNNER;
            sb.append(base).append("?");
            params.put("_fb", bean);
            params.put("_fp", action);
            sb.append(this.getParamsMarkup(params));
            BeanHandler element = (BeanHandler)CDIBeanLocator.getBeanByNameOrType((String)bean);
            if (element != null) {
                element.setEnabledForActionHandling(true);
            } else {
                this.log.debug((Object)("Bean @Named as '" + bean + "' not found."));
            }
            return sb.toString();
        }
        catch (ClassCastException cce) {
            this.log.error((Object)("Bean " + bean + " is not a BeanHandler."));
            return "#";
        }
    }

    public String getServletMapping() {
        return COMMAND_RUNNER;
    }

    public String getBaseURI() {
        return this.getServletMapping();
    }

    public String getMarkup(String bean, String action, Map params) {
        try {
            StringBuffer sb = new StringBuffer();
            BeanHandler component = (BeanHandler)CDIBeanLocator.getBeanByNameOrType((String)bean);
            params.put("_fb", bean);
            params.put("_fp", component.getActionName(action));
            sb.append(this.getServletMapping()).append("?");
            sb.append(this.getParamsMarkup(params));
            component.setEnabledForActionHandling(true);
            return sb.toString();
        }
        catch (ClassCastException cce) {
            this.log.error((Object)("Bean " + bean + " is not a BeanHandler."));
            return "#";
        }
    }

    public String getParamsMarkup(Map params) {
        StringBuffer sb = new StringBuffer();
        Iterator it = params.keySet().iterator();
        while (it.hasNext()) {
            String paramName = (String)it.next();
            Object paramValue = params.get(paramName);
            sb.append(this.getParameterMarkup(paramName, paramValue));
            if (!it.hasNext()) continue;
            sb.append("&amp;");
        }
        return sb.toString();
    }

    protected String getParameterMarkup(String name, Object value) {
        StringBuffer sb = new StringBuffer();
        try {
            HTTPSettings httpSettings = HTTPSettings.lookup();
            sb.append(URLEncoder.encode(name, httpSettings.getEncoding())).append("=").append(URLEncoder.encode(String.valueOf(value), httpSettings.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)"Error: ", (Throwable)e);
        }
        return sb.toString();
    }

    public String getContextHost(ServletRequest request) {
        StringBuffer sb = new StringBuffer();
        String context = ((HttpServletRequest)request).getContextPath();
        String protocol = request.getScheme();
        while (context.startsWith("/")) {
            context = context.substring(1);
        }
        sb.append(protocol.toLowerCase()).append("://").append(request.getServerName());
        if (request.getServerPort() != 80) {
            sb.append(":").append(request.getServerPort());
        }
        return sb.toString();
    }
}

