/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.controller;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.service.Application;
import org.jbpm.formModeler.service.bb.mvc.components.ControllerStatus;
import org.jbpm.formModeler.service.bb.mvc.components.CurrentComponentRenderer;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.ControllerServletHelper;
import org.jbpm.formModeler.service.bb.mvc.controller.HTTPSettings;
import org.jbpm.formModeler.service.bb.mvc.controller.RequestProcessor;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.ShowCurrentScreenResponse;
import org.jbpm.formModeler.service.error.ErrorManager;
import org.jbpm.formModeler.service.error.ErrorReport;
import org.jbpm.formModeler.service.error.ErrorReportHandler;

public class ControllerServlet
extends HttpServlet {
    private static transient Log log = LogFactory.getLog((String)ControllerServlet.class.getName());
    public static final String INIT_PARAM_CFG_DIR = "base.cfg.dir";
    public static final String INIT_PARAM_APP_DIR = "base.app.dir";
    private static Application theApp;
    private static boolean initSuccess;
    private static Throwable initException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initError() {
        File outputFile = new File(Application.lookup().getBaseAppDirectory() + "/ControllerError.txt");
        OutputStreamWriter writer = null;
        try {
            StringWriter sw = new StringWriter();
            initException.printStackTrace(new PrintWriter(sw));
            writer = new FileWriter(outputFile);
            writer.write(initException.getMessage() + "\n" + sw.toString());
            outputFile.deleteOnExit();
            sw.close();
        }
        catch (IOException e1) {
            log.error((Object)"Error writing to log file: ", (Throwable)e1);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e2) {
                    log.error((Object)"Error closing log file: ", (Throwable)e2);
                }
            }
        }
    }

    protected void initApp() throws ServletException {
        try {
            String baseCfgDir;
            String baseAppDir = this.getInitParameter(INIT_PARAM_APP_DIR);
            if (baseAppDir == null) {
                baseAppDir = new File(this.getServletContext().getRealPath(".")).getPath();
                baseAppDir = StringUtils.replace((String)baseAppDir, (String)"\\", (String)"/");
                log.info((Object)("Application Directory: " + baseAppDir));
            }
            if ((baseCfgDir = this.getInitParameter(INIT_PARAM_CFG_DIR)) == null) {
                baseCfgDir = baseAppDir + "/WEB-INF/etc";
                log.info((Object)("Application Config Directory: " + baseCfgDir));
            }
            theApp = Application.lookup();
            theApp.setBaseAppDirectory(baseAppDir);
            theApp.setBaseCfgDirectory(baseCfgDir);
            theApp.start();
            initSuccess = true;
        }
        catch (Throwable e) {
            log.error((Object)"Error initializing application. Marking it as uninitialized ", e);
            initException = e;
            initSuccess = false;
            this.initError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (theApp == null) {
            this.initApp();
        }
        if (initSuccess) {
            try {
                HTTPSettings settings = HTTPSettings.lookup();
                request.setCharacterEncoding(settings.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Error: ", (Throwable)e);
            }
            ControllerServletHelper helper = ControllerServletHelper.lookup();
            CommandRequest cmdRq = helper.initThreadLocal(request, response);
            ControllerStatus.lookup().setRequest(cmdRq);
            try {
                this.processTheRequest(cmdRq);
                this.processTheView(cmdRq);
            }
            finally {
                helper.clearThreadLocal(request, response);
            }
        }
        log.error((Object)"Received request, but application servlet hasn't been properly initialized. Ignoring.");
        response.sendError(500, "Application incorrectly initialized.");
    }

    protected void processTheRequest(CommandRequest request) {
        try {
            RequestProcessor.lookup().run();
            if ("GET".equalsIgnoreCase(request.getRequestObject().getMethod())) {
                ControllerStatus.lookup().compareConsumedUri();
            }
        }
        catch (Throwable e) {
            this.displayTheError(e);
        }
    }

    protected void processTheView(CommandRequest request) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rendering response. Id=" + Thread.currentThread().getName()));
            }
            CommandResponse cmdResponse = ControllerStatus.lookup().getResponse();
            cmdResponse.execute(request);
        }
        catch (Throwable e) {
            log.error((Object)"Error painting response. User might have seen something ugly in the browser if he is still there.", e);
        }
    }

    protected void displayTheError(Throwable t) {
        ErrorReport report = ErrorManager.lookup().getErrorReport();
        ErrorReportHandler errorHandler = ErrorReportHandler.lookup();
        errorHandler.setWidth(1000);
        errorHandler.setHeight(400);
        errorHandler.setErrorReport(report);
        CurrentComponentRenderer.lookup().setCurrentComponent(errorHandler);
        ControllerStatus controllerStatus = ControllerStatus.lookup();
        controllerStatus.setResponse(new ShowCurrentScreenResponse());
    }

    public void destroy() {
        Application.lookup().shutdown();
        log.debug((Object)"Destroying controller servlet");
    }

    static {
        initSuccess = true;
    }
}

