/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.controller;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestMultipartWrapper
extends HttpServletRequestWrapper {
    private static Log log = LogFactory.getLog((String)RequestMultipartWrapper.class.getName());
    protected Map<String, FileItem> requestFiles = new Hashtable<String, FileItem>();
    protected Map<String, List<String>> requestParameters = new Hashtable<String, List<String>>();
    protected Map<String, File> uploadedFiles = new Hashtable<String, File>();
    private String privateDir = null;
    private String encoding = null;

    public RequestMultipartWrapper(HttpServletRequest request, String saveDirectory, int maxPostSize, String encoding) throws IOException {
        super(request);
        this.privateDir = saveDirectory;
        this.encoding = encoding;
        DiskFileItemFactory factory = new DiskFileItemFactory();
        if (this.privateDir != null) {
            File dir = new File(this.privateDir);
            if (dir.isDirectory() && dir.canWrite()) {
                factory.setRepository(dir);
            } else {
                log.warn((Object)("Directory " + this.privateDir + " is not valid or permissions to write not granted"));
            }
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax((long)maxPostSize);
        List items = null;
        try {
            items = upload.parseRequest(request);
        }
        catch (FileUploadException e) {
            throw new IOException("Error parsing multipart in URI" + request.getRequestURI(), e);
        }
        if (items != null) {
            for (FileItem item : items) {
                if (item.isFormField()) {
                    this.addFormField(item);
                    continue;
                }
                try {
                    this.addUploadedFile(item);
                }
                catch (Exception e) {
                    throw new IOException("Error parsing multipart item " + item.getName(), e);
                }
            }
        }
    }

    protected void addFormField(FileItem item) throws IOException {
        String name = item.getFieldName();
        String itemValue = null;
        if (name != null) {
            List<String> values = this.requestParameters.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.requestParameters.put(name, values);
            }
            if ((itemValue = item.getString(this.encoding)) != null) {
                values.add(itemValue);
            }
        }
    }

    protected void addUploadedFile(FileItem item) throws Exception {
        if (!item.isFormField()) {
            String fieldName = item.getFieldName();
            String fileName = item.getName();
            if (fileName != null && !fileName.trim().equals("")) {
                fileName = new File(item.getName()).getName();
            }
            if (fileName != null && !fileName.trim().equals("")) {
                File uploadedFile = new File(this.privateDir, fileName);
                item.write(uploadedFile);
                uploadedFile.deleteOnExit();
                if (uploadedFile.exists() && uploadedFile.length() > 0L && uploadedFile.canRead()) {
                    this.requestFiles.put(fieldName, item);
                    this.uploadedFiles.put(fieldName, uploadedFile);
                }
            }
        }
    }

    public Enumeration getParameterNames() {
        Vector<String> names = new Vector<String>(this.requestParameters.size() + this.requestFiles.size());
        names.addAll(this.requestParameters.keySet());
        names.addAll(this.requestFiles.keySet());
        return names.elements();
    }

    public String getParameter(String name) {
        List<String> values = this.requestParameters.get(name);
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    public String[] getParameterValues(String name) {
        List<String> values = this.requestParameters.get(name);
        return values == null || values.isEmpty() ? null : values.toArray(new String[0]);
    }

    public Map getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration enumParameters = this.getParameterNames();
        while (enumParameters.hasMoreElements()) {
            String name = (String)enumParameters.nextElement();
            String[] values = this.getParameterValues(name);
            if (values == null) continue;
            map.put(name, values);
        }
        return map;
    }

    public Enumeration getFileParameterNames() {
        Vector<String> names = new Vector<String>(this.requestFiles.size());
        names.addAll(this.requestFiles.keySet());
        return names.elements();
    }

    public File getUploadedFile(String parameter) {
        return this.uploadedFiles.get(parameter);
    }
}

