/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.controller.requestChain;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.service.bb.mvc.components.ControllerStatus;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.requestChain.RequestChainProcessor;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.SendErrorResponse;

public class FreeMemoryProcessor
implements RequestChainProcessor {
    private static transient Log log = LogFactory.getLog((String)FreeMemoryProcessor.class.getName());
    private long minMemorySize = 1000000L;
    private float minMemoryPercentage = 0.05f;

    public long getMinMemorySize() {
        return this.minMemorySize;
    }

    public void setMinMemorySize(long minMemorySize) {
        this.minMemorySize = minMemorySize;
    }

    public float getMinMemoryPercentage() {
        return this.minMemoryPercentage;
    }

    public void setMinMemoryPercentage(float minMemoryPercentage) {
        this.minMemoryPercentage = minMemoryPercentage;
    }

    @Override
    public boolean processRequest(CommandRequest request) throws Exception {
        long totalMemory;
        long freeMemory = Runtime.getRuntime().freeMemory();
        if (this.isLowMemory(freeMemory, totalMemory = Runtime.getRuntime().totalMemory())) {
            log.warn((Object)"Memory is running low ...");
            this.freeSomeMemory(freeMemory, totalMemory);
            freeMemory = Runtime.getRuntime().freeMemory();
            totalMemory = Runtime.getRuntime().totalMemory();
            if (this.isLowMemory(freeMemory, totalMemory)) {
                ControllerStatus.lookup().setResponse(new SendErrorResponse(503));
                ControllerStatus.lookup().consumeURIPart(ControllerStatus.lookup().getURIToBeConsumed());
                log.error((Object)"Memory is so low that a user request had to be canceled - 503 sent. Consider increasing memory for current running application.");
                return false;
            }
        }
        return true;
    }

    protected void freeSomeMemory(long freeMemory, long totalMemory) {
        System.gc();
        long newFreeMemory = Runtime.getRuntime().freeMemory();
        long newTotalMemory = Runtime.getRuntime().totalMemory();
        if (this.isLowMemory(newFreeMemory, newTotalMemory)) {
            this.freeEvenMoreMemory(newFreeMemory, newTotalMemory);
        } else {
            float percentage = (float)((double)newFreeMemory * 100.0 / ((double)newTotalMemory * 1.0));
            log.warn((Object)("Freed " + (newFreeMemory - freeMemory) + " bytes. Now memory is OK to go on. (" + percentage + "% free)"));
        }
    }

    protected void freeEvenMoreMemory(long freeMemory, long totalMemory) {
        System.gc();
        long newFreeMemory = Runtime.getRuntime().freeMemory();
        long newTotalMemory = Runtime.getRuntime().totalMemory();
        if (!this.isLowMemory(newFreeMemory, newTotalMemory)) {
            float percentage = (float)((double)newFreeMemory / ((double)newTotalMemory * 1.0));
            log.warn((Object)("Hibernate caches had to be deleted to free memory. Consider decreasing cache sizes, or increasing memory for current application. Freed " + (newFreeMemory - freeMemory) + " bytes. Now memory us OK to go on. (" + percentage + "% free)"));
        }
    }

    protected boolean isLowMemory(long freeMemory, long totalMemory) {
        if (freeMemory < this.minMemorySize) {
            return true;
        }
        float percentage = (float)((double)freeMemory / ((double)totalMemory * 1.0));
        return percentage < this.minMemoryPercentage;
    }
}

