/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.controller.requestChain;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.service.bb.mvc.components.ControllerStatus;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.requestChain.RequestChainProcessor;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.RedirectToURLResponse;

public class SessionInitializer
implements RequestChainProcessor {
    private static transient Log log = LogFactory.getLog((String)SessionInitializer.class.getName());
    private static final String SESSION_ATTRIBUTE_INITIALIZED = "controller.initialized";

    @Override
    public boolean processRequest(CommandRequest request) throws Exception {
        boolean isNewSession;
        HttpServletRequest httpReq = request.getRequestObject();
        HttpSession session = httpReq.getSession(true);
        boolean bl = isNewSession = !"true".equals(session.getAttribute(SESSION_ATTRIBUTE_INITIALIZED));
        if (isNewSession) {
            this.initSession(httpReq);
        }
        if (httpReq.getRequestedSessionId() != null && !httpReq.getRequestedSessionId().equals(session.getId())) {
            this.handleExpiration(httpReq);
            return false;
        }
        if (!this.verifySession(session)) {
            throw new Exception("Session verification failed.");
        }
        return true;
    }

    protected void initSession(HttpServletRequest httpReq) {
        httpReq.getSession().setAttribute(SESSION_ATTRIBUTE_INITIALIZED, (Object)"true");
    }

    protected boolean verifySession(HttpSession session) {
        boolean error = false;
        Object initialized = session.getAttribute(SESSION_ATTRIBUTE_INITIALIZED);
        if (!"true".equals(initialized)) {
            log.error((Object)"Current session seems to be not initialized.");
            error = true;
        }
        return !error;
    }

    protected void handleExpiration(HttpServletRequest httpReq) {
        log.debug((Object)"Session expiration detected.");
        ControllerStatus controllerStatus = ControllerStatus.lookup();
        controllerStatus.setResponse(new RedirectToURLResponse(httpReq.getRequestURI()));
        controllerStatus.consumeURIPart(controllerStatus.getURIToBeConsumed());
    }
}

