/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.controller.responses;

import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandResponse;
import org.jbpm.formModeler.service.bb.mvc.taglib.ContextTag;

public class RedirectToURLResponse
implements CommandResponse {
    private String URL = null;
    private boolean isRelative = false;
    private static Log log = LogFactory.getLog((String)RedirectToURLResponse.class.getName());

    public RedirectToURLResponse(String newURL, boolean relative) {
        this.URL = newURL;
        this.isRelative = relative;
    }

    public RedirectToURLResponse(String newURL) {
        this(newURL, false);
    }

    @Override
    public boolean execute(CommandRequest cmdReq) throws Exception {
        HttpServletResponse res;
        if (log.isDebugEnabled()) {
            log.debug((Object)("RedirectToURLResponse: " + this.getURL()));
        }
        if ((res = cmdReq.getResponseObject()) != null) {
            res.sendRedirect(this.normalize(this.getURL(), cmdReq, this.isRelative()));
            return true;
        }
        log.error((Object)"Response object is null");
        return false;
    }

    protected String normalize(String url, CommandRequest cmdReq, boolean relative) {
        if (relative) {
            return ContextTag.getContextPath(url, cmdReq.getRequestObject());
        }
        return url;
    }

    public String getURL() {
        return this.URL;
    }

    public boolean isRelative() {
        return this.isRelative;
    }

    public String toString() {
        return "RedirectToURLResponse -> " + this.getURL();
    }
}

