/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.controller.responses;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.HTTPSettings;

public class SendStreamResponse
implements CommandResponse {
    private static Log log = LogFactory.getLog((String)SendStreamResponse.class.getName());
    protected InputStream is;
    protected String contentDisposition;
    protected int errorCode = 0;
    protected boolean resetHeaders = true;
    protected String contentType = "application/force-download";
    protected int contentLength = -1;

    public SendStreamResponse(InputStream is, String contentDisposition) {
        this.init(is, contentDisposition);
    }

    public SendStreamResponse(InputStream is, String contentDisposition, int contentLength) {
        this.contentLength = contentLength;
        this.init(is, contentDisposition);
    }

    public SendStreamResponse(File f) {
        try {
            this.init(new FileInputStream(f), "inline; filename=" + URLEncoder.encode(f.getName()) + ";");
            FileNameMap fileNameMap = URLConnection.getFileNameMap();
            this.contentType = fileNameMap.getContentTypeFor(f.getName());
        }
        catch (FileNotFoundException e) {
            log.error((Object)"Error:", (Throwable)e);
            this.errorCode = 404;
        }
    }

    public SendStreamResponse(InputStream is, String contentDisposition, boolean resetHeaders) {
        this.resetHeaders = resetHeaders;
        this.init(is, contentDisposition);
    }

    public SendStreamResponse(File f, boolean resetHeaders) {
        this(f);
        this.resetHeaders = resetHeaders;
    }

    protected void init(InputStream is, String contentDisposition) {
        this.is = new BufferedInputStream(is);
        this.contentDisposition = contentDisposition;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public boolean execute(CommandRequest cmdReq) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SendStreamResponse");
        }
        HttpServletResponse res = cmdReq.getResponseObject();
        if (this.errorCode != 0) {
            res.sendError(this.errorCode);
            return false;
        }
        if (this.resetHeaders) {
            res.reset();
        }
        res.setHeader("Content-Encoding", HTTPSettings.lookup().getEncoding());
        if (this.contentDisposition != null) {
            res.setHeader("Content-Disposition", this.contentDisposition);
            log.debug((Object)("Content-Disposition = " + this.contentDisposition));
        }
        if (this.contentType != null) {
            res.setContentType(this.contentType);
        }
        res.setHeader("Content-Transfer-Encoding", "binary");
        if (this.contentLength < 0) {
            this.contentLength = this.is.available();
        }
        if (this.contentLength > 0) {
            res.setContentLength(this.contentLength);
            log.debug((Object)("Content-Length = " + this.contentLength));
        }
        try {
            BufferedOutputStream os = new BufferedOutputStream((OutputStream)cmdReq.getResponseObject().getOutputStream());
            IOUtils.copy((InputStream)this.is, (OutputStream)os);
            ((OutputStream)os).close();
            this.is.close();
        }
        catch (Exception e) {
            log.warn((Object)("Error sending Stream Response: " + e));
            return false;
        }
        return true;
    }
}

