/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.taglib.formatter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForComparator
implements Comparator {
    private static transient Log log = LogFactory.getLog((String)ForComparator.class.getName());
    private List sortTokens = new ArrayList();

    public ForComparator(String sortProperties) {
        StringTokenizer stk = new StringTokenizer(sortProperties);
        while (stk.hasMoreTokens()) {
            this.sortTokens.add(stk.nextToken().trim());
        }
    }

    public int compare(Object o1, Object o2) {
        for (int i = 0; i < this.sortTokens.size(); ++i) {
            String property = (String)this.sortTokens.get(i);
            boolean descending = property.startsWith("-");
            if (property.startsWith("-") || property.startsWith("+")) {
                property = property.substring(1);
            }
            Object prop1 = this.getObjectProperty(o1, property);
            Object prop2 = this.getObjectProperty(o2, property);
            if (prop1 != null && prop2 != null) {
                if (prop1 instanceof Comparable && prop2 instanceof Comparable) {
                    int compareResult = ((Comparable)prop1).compareTo(prop2);
                    if (descending) {
                        compareResult *= -1;
                    }
                    if (compareResult == 0) continue;
                    return compareResult;
                }
                log.warn((Object)("Ignoring sort property " + property + " as it is not comparable."));
                continue;
            }
            log.warn((Object)("Ignoring sort property " + property + " as it is null for an item."));
        }
        return 0;
    }

    private Object getObjectProperty(Object object, String property) {
        JXPathContext ctx = JXPathContext.newContext((Object)object);
        try {
            return ctx.getValue(property);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid property '" + property + "' "), (Throwable)e);
            }
            return null;
        }
    }
}

