/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.taglib.formatter;

import java.util.Locale;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.jbpm.formModeler.service.LocaleManager;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormaterTagDynamicAttributesInterpreter;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterTag;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.ProcessingInstruction;

public abstract class Formatter {
    @Inject
    private Log log;
    private transient FormatterTag tag;
    private transient Locale currentLocale;
    private transient String currentLang;

    public void setTag(FormatterTag tag) {
        this.tag = tag;
    }

    protected LocaleManager getLocaleManager() {
        return LocaleManager.lookup();
    }

    protected Locale getLocale() {
        if (this.currentLocale != null) {
            return this.currentLocale;
        }
        this.currentLocale = this.getLocaleManager().getCurrentLocale();
        return this.currentLocale;
    }

    protected String getLang() {
        if (this.currentLang != null) {
            return this.currentLang;
        }
        this.currentLang = this.getLocaleManager().getCurrentLang();
        return this.currentLang;
    }

    protected void renderFragment(String fragmentName) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Rendering of fragment " + fragmentName + " scheduled."));
        }
        this.tag.addProcessingInstruction(ProcessingInstruction.getRenderFragmentInstruction(fragmentName));
    }

    protected void includePage(String pageName) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Including of page " + pageName + " scheduled."));
        }
        this.tag.addProcessingInstruction(ProcessingInstruction.getIncludePageInstruction(pageName));
    }

    protected void writeToOut(String text) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writting '" + text + "' to output,  scheduled."));
        }
        this.tag.addProcessingInstruction(ProcessingInstruction.getWriteToOutInstruction(text));
    }

    protected void setAttributeInterpreter(FormaterTagDynamicAttributesInterpreter interpreter) {
        this.tag.addProcessingInstruction(ProcessingInstruction.getAddAttributesInterpreterInstruction(interpreter));
    }

    protected void setAttribute(String name, Object value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Setting of attribute " + name + " scheduled."));
        }
        this.tag.addProcessingInstruction(ProcessingInstruction.getSetParameterInstruction(name, value));
    }

    protected void setAttribute(String name, int value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Setting of attribute " + name + " scheduled."));
        }
        this.tag.addProcessingInstruction(ProcessingInstruction.getSetParameterInstruction(name, new Integer(value)));
    }

    protected void setAttribute(String name, byte value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Setting of attribute " + name + " scheduled."));
        }
        this.tag.addProcessingInstruction(ProcessingInstruction.getSetParameterInstruction(name, new Byte(value)));
    }

    protected void setAttribute(String name, long value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Setting of attribute " + name + " scheduled."));
        }
        this.tag.addProcessingInstruction(ProcessingInstruction.getSetParameterInstruction(name, new Long(value)));
    }

    protected void setAttribute(String name, short value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Setting of attribute " + name + " scheduled."));
        }
        this.tag.addProcessingInstruction(ProcessingInstruction.getSetParameterInstruction(name, new Short(value)));
    }

    protected void setAttribute(String name, boolean value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Setting of attribute " + name + " scheduled."));
        }
        this.tag.addProcessingInstruction(ProcessingInstruction.getSetParameterInstruction(name, new Boolean(value)));
    }

    protected void setAttribute(String name, char value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Setting of attribute " + name + " scheduled."));
        }
        this.tag.addProcessingInstruction(ProcessingInstruction.getSetParameterInstruction(name, new Character(value)));
    }

    protected void setAttribute(String name, float value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Setting of attribute " + name + " scheduled."));
        }
        this.tag.addProcessingInstruction(ProcessingInstruction.getSetParameterInstruction(name, new Float(value)));
    }

    protected void setAttribute(String name, double value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Setting of attribute " + name + " scheduled."));
        }
        this.tag.addProcessingInstruction(ProcessingInstruction.getSetParameterInstruction(name, new Double(value)));
    }

    protected Object getParameter(String name) {
        return this.tag.getParam(name);
    }

    public abstract void service(HttpServletRequest var1, HttpServletResponse var2) throws FormatterException;

    public void afterRendering(HttpServletRequest request, HttpServletResponse response) throws FormatterException {
    }
}

