/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.taglib.formatter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormaterTagDynamicAttributesInterpreter;

public class ProcessingInstruction {
    private static transient Log log = LogFactory.getLog((String)ProcessingInstruction.class.getName());
    public static final int RENDER_FRAGMENT = 0;
    public static final int SET_ATTRIBUTE = 1;
    public static final int INCLUDE_PAGE = 2;
    public static final int WRITE_OUT = 3;
    public static final int SET_DYNAMIC_ATTRIBUTES_INTERPRETER = 4;
    private int type;
    private String name;
    private Object value;

    public static ProcessingInstruction getRenderFragmentInstruction(String fragmentName) {
        ProcessingInstruction pi = new ProcessingInstruction();
        pi.type = 0;
        pi.name = fragmentName;
        pi.value = null;
        return pi;
    }

    public static ProcessingInstruction getSetParameterInstruction(String paramName, Object paramValue) {
        ProcessingInstruction pi = new ProcessingInstruction();
        pi.type = 1;
        pi.name = paramName;
        pi.value = paramValue;
        return pi;
    }

    public static ProcessingInstruction getIncludePageInstruction(String pageName) {
        ProcessingInstruction pi = new ProcessingInstruction();
        pi.type = 2;
        pi.name = pageName;
        return pi;
    }

    public static ProcessingInstruction getWriteToOutInstruction(String text) {
        ProcessingInstruction pi = new ProcessingInstruction();
        pi.type = 3;
        pi.value = text;
        return pi;
    }

    public static ProcessingInstruction getAddAttributesInterpreterInstruction(FormaterTagDynamicAttributesInterpreter interpreter) {
        ProcessingInstruction pi = new ProcessingInstruction();
        pi.type = 4;
        pi.value = interpreter;
        return pi;
    }

    private ProcessingInstruction() {
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[ ");
        if (this.type == 0) {
            sb.append("Render ");
            sb.append(this.name);
        } else if (this.type == 1) {
            sb.append("Set ");
            sb.append(this.name);
            sb.append(" = ");
            sb.append(this.value);
        } else if (this.type == 2) {
            sb.append("Include ");
            sb.append(this.name);
        } else if (this.type == 3) {
            sb.append("Write ");
            sb.append(this.value);
        }
        sb.append(" ]");
        return sb.toString();
    }
}

