/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.components;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.lang.StringEscapeUtils;
import org.jbpm.formModeler.service.bb.mvc.components.handling.BeanHandler;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HandlerMarkupGenerator {
    private Logger log = LoggerFactory.getLogger(HandlerMarkupGenerator.class);

    public static HandlerMarkupGenerator lookup() {
        return (HandlerMarkupGenerator)CDIBeanLocator.getBeanByType(HandlerMarkupGenerator.class);
    }

    public String getMarkup(String bean, String property) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getHiddenMarkup("_fb", bean));
        sb.append(this.getHiddenMarkup("_fp", property));
        try {
            BeanHandler element = (BeanHandler)CDIBeanLocator.getBeanByNameOrType((String)bean);
            element.setEnabledForActionHandling(true);
            Map<String, String> params = element.getExtraActionParams();
            if (params != null && !params.isEmpty()) {
                for (String key : params.keySet()) {
                    sb.append(this.getHiddenMarkup(key, params.get(key)));
                }
            }
        }
        catch (ClassCastException cce) {
            this.log.error("Bean " + bean + " is not a BeanHandler.");
        }
        return sb.toString();
    }

    protected String getHiddenMarkup(String name, String value) {
        name = StringEscapeUtils.escapeHtml((String)name);
        value = StringEscapeUtils.escapeHtml((String)value);
        return "<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\">";
    }
}

