/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.components.handling;

import java.util.List;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.formModeler.service.annotation.config.Config;
import org.jbpm.formModeler.service.bb.mvc.components.handling.MessagesComponentHandler;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.Formatter;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="MessagesComponentFormatter")
public class MessagesComponentFormatter
extends Formatter {
    private Logger log = LoggerFactory.getLogger(MessagesComponentFormatter.class);
    @Inject
    @Config(value="5")
    private int maxVisibleErrors;
    @Inject
    @Config(value="/formModeler/components/messages/images/32x32/info.gif")
    private String messagesImg;
    @Inject
    @Config(value="/formModeler/components/messages/images/32x32/warning.gif")
    private String warningsImg;
    @Inject
    @Config(value="/formModeler/components/messages/images/32x32/error.gif")
    private String errorsImg;
    @Inject
    @Config(value="5")
    private String classForMessages;
    @Inject
    @Config(value="skn-error")
    private String classForWarnings;
    @Inject
    @Config(value="skn-error")
    private String classForErrors;

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws FormatterException {
        MessagesComponentHandler messagesComponentHandler = MessagesComponentHandler.lookup();
        if (messagesComponentHandler.getErrorsToDisplay() != null && messagesComponentHandler.getErrorsToDisplay().size() > 0) {
            this.renderMessages(messagesComponentHandler.getErrorsToDisplay(), messagesComponentHandler.getErrorsParameters(), this.errorsImg, this.classForErrors);
        } else if (messagesComponentHandler.getWarningsToDisplay() != null && messagesComponentHandler.getWarningsToDisplay().size() > 0) {
            this.renderMessages(messagesComponentHandler.getWarningsToDisplay(), messagesComponentHandler.getWarningsParameters(), this.warningsImg, this.classForWarnings);
        } else if (messagesComponentHandler.getMessagesToDisplay() != null && messagesComponentHandler.getMessagesToDisplay().size() > 0) {
            this.renderMessages(messagesComponentHandler.getMessagesToDisplay(), messagesComponentHandler.getMessagesParameters(), this.messagesImg, this.classForMessages);
        }
    }

    protected void renderMessages(List messages, List params, String img, String className) {
        MessagesComponentHandler messagesComponentHandler = MessagesComponentHandler.lookup();
        while (messages.size() > params.size()) {
            params.add(null);
        }
        long id = System.currentTimeMillis();
        boolean maxRised = false;
        this.setAttribute("image", img);
        this.setAttribute("bundle", messagesComponentHandler.getI18nBundle());
        this.renderFragment("outputStart");
        this.renderFragment("outputVisibleMessagesStart");
        for (int i = 0; i < messages.size(); ++i) {
            if (i == this.maxVisibleErrors) {
                this.renderFragment("outputMessagesEnd");
                this.renderFragment("outputNewLine");
                this.setAttribute("id", id);
                this.renderFragment("outputHiddenMessagesStart");
                maxRised = true;
            }
            this.setAttribute("bundle", messagesComponentHandler.getI18nBundle());
            this.setAttribute("msg", messages.get(i));
            this.setAttribute("params", params.get(i));
            this.setAttribute("className", className);
            this.renderFragment("outputMessage");
        }
        this.renderFragment("outputMessagesEnd");
        if (maxRised) {
            this.renderFragment("outputNewLine");
            this.setAttribute("id", id);
            this.renderFragment("outputDisplayLinks");
        }
        this.renderFragment("outputEnd");
        if (messagesComponentHandler.isClearAfterRender()) {
            messagesComponentHandler.clearAll();
        }
    }

    protected String localizeMessage(String message) {
        block3: {
            MessagesComponentHandler messagesComponentHandler = MessagesComponentHandler.lookup();
            try {
                if (messagesComponentHandler.getI18nBundle() != null) {
                    ResourceBundle bundle = ResourceBundle.getBundle(messagesComponentHandler.getI18nBundle(), this.getLocale());
                    message = bundle.getString(message);
                }
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug("Error trying to get message '" + message + "' from bundle '" + messagesComponentHandler.getI18nBundle());
            }
        }
        return message;
    }
}

