/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.controller;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.jbpm.formModeler.service.bb.mvc.controller.RequestContext;
import org.jbpm.formModeler.service.bb.mvc.controller.requestChain.BeanDispatcher;
import org.jbpm.formModeler.service.bb.mvc.controller.requestChain.FreeMemoryProcessor;
import org.jbpm.formModeler.service.bb.mvc.controller.requestChain.MultipartProcessor;
import org.jbpm.formModeler.service.bb.mvc.controller.requestChain.RequestChainProcessor;
import org.jbpm.formModeler.service.bb.mvc.controller.requestChain.ResponseHeadersProcessor;
import org.jbpm.formModeler.service.bb.mvc.controller.requestChain.SessionInitializer;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

@ApplicationScoped
public class RequestProcessor {
    protected List<RequestChainProcessor> requestProcessorChain = new ArrayList<RequestChainProcessor>();

    public static RequestProcessor lookup() {
        return (RequestProcessor)CDIBeanLocator.getBeanByType(RequestProcessor.class);
    }

    @PostConstruct
    protected void initChain() {
        this.requestProcessorChain.add(new ResponseHeadersProcessor());
        this.requestProcessorChain.add(new MultipartProcessor());
        this.requestProcessorChain.add(new FreeMemoryProcessor());
        this.requestProcessorChain.add(new SessionInitializer());
        this.requestProcessorChain.add(new BeanDispatcher());
    }

    public void run() throws Exception {
        for (RequestChainProcessor processor : this.requestProcessorChain) {
            RequestContext reqCtx;
            if (processor.processRequest((reqCtx = RequestContext.getCurrentContext()).getRequest())) continue;
            return;
        }
    }
}

