/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.taglib;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.service.bb.mvc.components.URLMarkupGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextTag
extends BodyTagSupport {
    private static transient Logger log = LoggerFactory.getLogger((String)ContextTag.class.getName());
    public static final String INCLUDE_HOST = "org.jbpm.formModeler.service.bb.mvc.taglib.ContextTag/includeHost";
    private String uri;
    private boolean includeHost = false;

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean isIncludeHost() {
        return this.includeHost;
    }

    public void setIncludeHost(boolean includeHost) {
        this.includeHost = includeHost;
    }

    public final int doStartTag() throws JspException {
        try {
            if (this.id != null) {
                String value = ContextTag.getContextPath(this.uri, (HttpServletRequest)this.pageContext.getRequest());
                this.pageContext.setAttribute(this.id, (Object)value);
            }
        }
        catch (Exception e) {
            log.error("Error:", (Throwable)e);
            throw new JspException((Throwable)e);
        }
        return 2;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.bodyContent == null) {
                String value = ContextTag.getContextPath(this.uri, (HttpServletRequest)this.pageContext.getRequest());
                if (this.includeHost || this.isGlobalIncludeHost()) {
                    this.pageContext.getOut().print(this.getContextHost());
                }
                this.pageContext.getOut().print(value == null ? "" : value);
            } else {
                this.pageContext.getOut().print(this.bodyContent.getString());
            }
        }
        catch (IOException e) {
            log.error("Error:", (Throwable)e);
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    protected boolean isGlobalIncludeHost() {
        return Boolean.TRUE.equals(this.pageContext.getRequest().getAttribute(INCLUDE_HOST));
    }

    public String getContextHost() {
        URLMarkupGenerator urlmg = URLMarkupGenerator.lookup();
        return urlmg.getContextHost(this.pageContext.getRequest());
    }

    public static String getContextPath(String uri, HttpServletRequest request) {
        uri = StringUtils.defaultString((String)uri);
        while (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        String cxPath = StringUtils.defaultString((String)request.getContextPath());
        while (cxPath.startsWith("/")) {
            cxPath = cxPath.substring(1);
        }
        while (cxPath.endsWith("/")) {
            cxPath = cxPath.substring(0, cxPath.length() - 1);
        }
        String fullUri = StringUtils.isEmpty((CharSequence)cxPath) ? "/" + uri : "/" + cxPath + "/" + uri;
        return StringUtils.replace((String)fullUri, (String)"//", (String)"/");
    }

    public static class TEI
    extends TagExtraInfo {
        public VariableInfo[] getVariableInfo(TagData data) {
            String varName = data.getId();
            if (varName == null) {
                return new VariableInfo[0];
            }
            return new VariableInfo[]{new VariableInfo(varName, "java.lang.String", true, 0)};
        }
    }
}

