/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.controller.requestChain;

import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.service.bb.mvc.components.ControllerStatus;
import org.jbpm.formModeler.service.bb.mvc.components.handling.BeanHandler;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.requestChain.RequestChainProcessor;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanDispatcher
implements RequestChainProcessor {
    private static transient Logger log = LoggerFactory.getLogger(BeanDispatcher.class);

    @Override
    public boolean processRequest(CommandRequest request) throws Exception {
        CommandResponse response = this.handleRequest(request);
        if (request.getRequestObject().getServletPath().indexOf("/Controller") != -1) {
            ControllerStatus.lookup().consumeURIPart(ControllerStatus.lookup().getURIToBeConsumed());
        }
        ControllerStatus.lookup().setResponse(response);
        return true;
    }

    public CommandResponse handleRequest(CommandRequest request) throws Exception {
        String beanName = request.getRequestObject().getParameter("_fb");
        String beanAction = request.getRequestObject().getParameter("_fp");
        if (!StringUtils.isEmpty((CharSequence)beanName) && !StringUtils.isEmpty((CharSequence)beanAction)) {
            try {
                BeanHandler bean = (BeanHandler)CDIBeanLocator.getBeanByNameOrType((String)beanName);
                if (bean != null) {
                    return bean.handle(request, beanAction);
                }
                log.error("Unexistant bean specified for request handling: " + beanName);
            }
            catch (ClassCastException cce) {
                log.error("Bean " + beanName + " is not a BeanHandler.");
            }
            catch (Exception e) {
                log.error("Exception ", (Throwable)e);
            }
        }
        return null;
    }
}

