/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.components;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.RedirectToURLResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.ShowScreenResponse;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
public class ControllerStatus
implements Serializable {
    private Logger log = LoggerFactory.getLogger(ControllerStatus.class);
    private CommandResponse response;
    private Throwable exception;
    private String showPage = "/formModeler/controllerResponse.jsp";
    private String currentComponentPage;
    private String requestURI;
    private StringBuffer consumedRequestURI;
    private CommandRequest request;

    public static ControllerStatus lookup() {
        return (ControllerStatus)CDIBeanLocator.getBeanByType(ControllerStatus.class);
    }

    @PostConstruct
    public void init() {
        this.response = new ShowScreenResponse(this.showPage);
    }

    public String getShowPage() {
        return this.showPage;
    }

    public void setShowPage(String showPage) {
        this.showPage = showPage;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Throwable getException() {
        return this.exception;
    }

    public CommandResponse getResponse() {
        return this.response;
    }

    public void setResponse(CommandResponse response) {
        if (response == null) {
            response = new ShowScreenResponse(this.showPage);
        }
        this.response = response;
    }

    protected StringBuffer getConsumedRequestURI() {
        return this.consumedRequestURI;
    }

    public void setURIToBeConsumed(String requestURI) {
        this.requestURI = StringUtils.replace((String)requestURI, (String)"//", (String)"/");
        this.consumedRequestURI = new StringBuffer();
    }

    public String getURIToBeConsumed() {
        return this.requestURI;
    }

    public void consumeURIPart(String uriPart) {
        this.consumedRequestURI.append(uriPart);
    }

    public void compareConsumedUri() {
        String consumedUri = StringUtils.replace((String)this.consumedRequestURI.toString(), (String)"//", (String)"/");
        if (consumedUri.endsWith("/")) {
            consumedUri = consumedUri.substring(0, consumedUri.length() - 1);
        }
        if (!this.requestURI.equals(consumedUri)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received URI: " + this.requestURI);
                this.log.debug("Consumed URI: " + consumedUri);
            }
            if (StringUtils.isEmpty((CharSequence)consumedUri)) {
                this.log.error("No part of the received uri " + this.requestURI + " has been consumed. Trying to serve it as good as possible.");
            } else if (this.requestURI.startsWith(consumedUri)) {
                String uriToForward;
                this.setResponse(new RedirectToURLResponse(uriToForward, !(uriToForward = this.requestURI.substring(consumedUri.length())).startsWith(this.request.getRequestObject().getContextPath())));
                this.log.warn("Redirecting to static uri: " + uriToForward);
            } else {
                this.log.debug("Consumed uri " + consumedUri + " is not even part of request uri: " + this.requestURI + ". Trying to serve it as good as possible.");
            }
        }
    }

    public void setRequest(CommandRequest commandRequest) {
        this.request = commandRequest;
        this.setURIToBeConsumed(this.request.getRequestObject().getRequestURI().substring(this.request.getRequestObject().getContextPath().length()));
    }

    public CommandRequest getRequest() {
        return this.request;
    }

    public String getCurrentComponentPage() {
        return this.currentComponentPage;
    }

    public void setCurrentComponentPage(String currentComponentPage) {
        this.currentComponentPage = currentComponentPage;
    }
}

