/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.taglib.formatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormaterTagDynamicAttributesInterpreter;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.Formatter;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.ProcessingInstruction;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatterTag
extends BodyTagSupport {
    private static transient Logger log = LoggerFactory.getLogger(FormatterTag.class);
    public static final int STAGE_READING_PARAMS = 1;
    public static final int STAGE_RENDERING_FRAGMENTS = 2;
    private int currentStage;
    private Formatter formatter;
    private String currentEnabledFragment = "";
    private List processingInstructions = new ArrayList();
    private int currentProcessingInstruction = 0;
    protected Object name;
    protected HashMap params = new HashMap();
    protected HashMap fragmentParams = new HashMap();
    protected FormaterTagDynamicAttributesInterpreter formaterTagDynamicAttributesInterpreter = null;
    protected Set fragments = new HashSet();

    public void clearFragmentParams() {
        this.fragmentParams.clear();
    }

    public HashMap getFragmentParams() {
        return this.fragmentParams;
    }

    public FormaterTagDynamicAttributesInterpreter getFormaterTagDynamicAttributesInterpreter() {
        return this.formaterTagDynamicAttributesInterpreter;
    }

    public Object getName() {
        return this.name;
    }

    public void setName(Object name) {
        this.name = name;
    }

    public void setParam(String name, Object value) throws JspException {
        if (this.params.containsKey(name)) {
            throw new JspException("Duplicated param name \"" + name + '\"');
        }
        this.params.put(name, value);
    }

    public void addFragment(String name) throws JspException {
        if (this.fragments.contains(name)) {
            throw new JspException("Duplicated fragment name \"" + name + '\"');
        }
        this.fragments.add(name);
    }

    public String getCurrentEnabledFragment() {
        return this.currentEnabledFragment;
    }

    public int getCurrentStage() {
        return this.currentStage;
    }

    public final int doStartTag() throws JspException {
        this.currentStage = 1;
        this.formatter = this.name instanceof Formatter ? (Formatter)this.name : (Formatter)CDIBeanLocator.getBeanByNameOrType((String)String.valueOf(this.name));
        if (this.formatter == null) {
            log.error("Unable to find formatter @Named " + this.name + " or through class name. ");
            return 0;
        }
        this.formatter.setTag(this);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doAfterBody() throws JspException {
        Integer result = 0;
        try {
            if (this.currentStage == 1) {
                this.currentStage = 2;
                if (this.formatter != null) {
                    Formatter formatter = this.formatter;
                    synchronized (formatter) {
                        this.formatter.service((HttpServletRequest)this.pageContext.getRequest(), (HttpServletResponse)this.pageContext.getResponse());
                    }
                }
            }
            while (this.currentProcessingInstruction < this.processingInstructions.size()) {
                ProcessingInstruction pi = (ProcessingInstruction)this.processingInstructions.get(this.currentProcessingInstruction++);
                if (log.isDebugEnabled()) {
                    log.debug("Processing instruction " + pi);
                }
                switch (pi.getType()) {
                    case 1: {
                        this.fragmentParams.put(pi.getName(), pi.getValue());
                        break;
                    }
                    case 0: {
                        this.currentEnabledFragment = pi.getName();
                        result = 2;
                        return result;
                    }
                    case 2: {
                        for (Map.Entry entry : this.fragmentParams.entrySet()) {
                            this.pageContext.getRequest().setAttribute((String)entry.getKey(), entry.getValue());
                        }
                        this.pageContext.include(pi.getName());
                        for (Map.Entry entry : this.fragmentParams.entrySet()) {
                            this.pageContext.getRequest().removeAttribute((String)entry.getKey());
                        }
                        this.clearFragmentParams();
                        break;
                    }
                    case 3: {
                        this.pageContext.getOut().print(pi.getValue());
                        this.clearFragmentParams();
                        break;
                    }
                    case 4: {
                        this.formaterTagDynamicAttributesInterpreter = (FormaterTagDynamicAttributesInterpreter)pi.getValue();
                    }
                }
            }
            if (!result.equals(2)) {
                this.formatter.afterRendering((HttpServletRequest)this.pageContext.getRequest(), (HttpServletResponse)this.pageContext.getResponse());
            }
        }
        catch (Throwable e) {
            throw new JspException(e);
        }
        return result;
    }

    public int doEndTag() throws JspException {
        this.currentEnabledFragment = "";
        this.processingInstructions = new ArrayList();
        this.currentProcessingInstruction = 0;
        this.params = new HashMap();
        this.fragmentParams = new HashMap();
        this.fragments = new HashSet();
        return 6;
    }

    public void addProcessingInstruction(ProcessingInstruction instruction) {
        this.processingInstructions.add(instruction);
    }

    public Object getParam(String name) {
        return this.params.get(name);
    }

    public void release() {
    }
}

