/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.fieldHandlers.SubformFieldHandler;
import org.jbpm.formModeler.core.rendering.SubformFinderService;

@Named(value="org.jbpm.formModeler.core.processing.fieldHandlers.CreateDynamicObjectFieldHandler")
public class CreateDynamicObjectFieldHandler
extends SubformFieldHandler
implements FieldHandler {
    private static transient Log log = LogFactory.getLog((String)CreateDynamicObjectFieldHandler.class.getName());
    public static final String CODE = "subformMultiple";
    @Inject
    private SubformFinderService subformFinderService;

    public CreateDynamicObjectFieldHandler() {
        this.setPageToIncludeForDisplaying("/formModeler/fieldHandlers/CreateDynamicObject/show.jsp");
        this.setPageToIncludeForRendering("/formModeler/fieldHandlers/CreateDynamicObject/input.jsp");
        this.setPageToIncludeForSearching("/formModeler/fieldHandlers/CreateDynamicObject/search.jsp");
    }

    @Override
    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        String[] editParams;
        boolean doSaveEdited;
        String[] createParams;
        boolean doCreate;
        String[] tableEnterMode = (String[])parametersMap.get(inputName + "." + "tableEnterMode");
        boolean doTableEnterMode = tableEnterMode != null && tableEnterMode.length == 1 && tableEnterMode[0].equals("true");
        String[] sCount = (String[])parametersMap.get(inputName + "." + "count");
        int count = sCount != null && sCount.length == 1 ? Integer.valueOf(sCount[0]) : 0;
        Form form = this.getTableDataForm(field, inputName);
        Object[] previousValuesMap = (Map[])previousValue;
        if (doTableEnterMode && count > 0) {
            if (previousValuesMap == null) {
                previousValuesMap = new Map[count];
            }
            for (int i = 0; i < count; ++i) {
                String namespace = inputName + "." + i;
                this.getFormProcessor().setValues(form, namespace, parametersMap, filesMap);
                FormStatusData status = this.getFormProcessor().read(form, namespace);
                if (!status.isValid()) continue;
                Map objectCreated = this.getFormProcessor().getMapRepresentationToPersist(form, namespace);
                if (previousValuesMap[i] != null) {
                    previousValuesMap[i].putAll(objectCreated);
                    continue;
                }
                previousValuesMap[i] = objectCreated;
            }
        }
        boolean bl = doCreate = (createParams = (String[])parametersMap.get(inputName + "." + "create")) != null && createParams.length == 1 && createParams[0].equals("true");
        if (doCreate) {
            Form createForm = this.getCreateForm(field, inputName);
            boolean addItemEnabled = Boolean.TRUE.equals(this.getFormProcessor().getAttribute(createForm, inputName, "-pot-doTheItemAdd"));
            if (addItemEnabled) {
                this.getFormProcessor().setValues(createForm, inputName + "." + "create", parametersMap, filesMap);
                FormStatusData status = this.getFormProcessor().read(createForm, inputName + "." + "create");
                if (status.isValid()) {
                    Map objectCreated = this.getFormProcessor().getMapRepresentationToPersist(createForm, inputName + "." + "create");
                    if (previousValuesMap == null) {
                        previousValuesMap = new Map[]{};
                    }
                    previousValuesMap = (Map[])ArrayUtils.add((Object[])previousValuesMap, (Object)objectCreated);
                    Form parentForm = field.getForm();
                    String parentNamespace = this.getNamespaceManager().getParentNamespace(inputName);
                    Set expandedFields = (Set)this.getFormProcessor().getAttribute(parentForm, parentNamespace, "-pot-expandedFields");
                    if (expandedFields != null) {
                        expandedFields.remove(field.getFieldName());
                        this.getFormProcessor().setAttribute(parentForm, parentNamespace, "-pot-expandedFields", (Object)expandedFields);
                    }
                    this.getFormProcessor().clear(form, parentNamespace);
                }
            }
        }
        boolean bl2 = doSaveEdited = (editParams = (String[])parametersMap.get(inputName + "." + "saveEdited")) != null && editParams.length == 1 && editParams[0].equals("true");
        if (doSaveEdited) {
            Form parentForm = field.getForm();
            String parentNamespace = this.getNamespaceManager().getParentNamespace(inputName);
            Map expandedFields = (Map)this.getFormProcessor().getAttribute(parentForm, parentNamespace, "-pot-editFieldPositions");
            if (expandedFields != null && !expandedFields.isEmpty()) {
                Integer positionStr = (Integer)expandedFields.get(field.getFieldName());
                int position = positionStr;
                Form editForm = this.getEditForm(field, inputName);
                this.getFormProcessor().setValues(editForm, inputName, parametersMap, filesMap);
                FormStatusData status = this.getFormProcessor().read(editForm, inputName);
                if (status.isValid()) {
                    Map objectCreated = this.getFormProcessor().getMapRepresentationToPersist(editForm, inputName);
                    previousValuesMap[position].putAll(objectCreated);
                    this.getFormProcessor().clear(editForm, inputName);
                    expandedFields.remove(field.getFieldName());
                    this.getFormProcessor().setAttribute(parentForm, parentNamespace, "-pot-editFieldPositions", (Object)expandedFields);
                }
            }
        }
        return previousValuesMap;
    }

    public Form calculateFieldForm(Field field, String formPath, String namespace) {
        if (StringUtils.isEmpty((String)formPath)) {
            formPath = field.getDefaultSubform();
        }
        return this.subformFinderService.getFormFromPath(formPath, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deleteElementInPosition(Form form, String namespace, String field, int position) {
        Form form2 = form;
        synchronized (form2) {
            FormStatusData statusData = this.getFormProcessor().read(form, namespace);
            Object[] previousValue = statusData.getCurrentValue(field);
            if (previousValue != null) {
                Object[] vals = previousValue;
                if (position < vals.length) {
                    previousValue = ArrayUtils.remove((Object[])vals, (int)position);
                } else {
                    log.error((Object)("Cannot delete position " + position + " in array with size " + vals.length));
                }
            } else {
                log.error((Object)("Cannot delete position " + position + " in null array."));
            }
            return previousValue;
        }
    }

    public Form getCreateForm(Field field, String namespace) {
        try {
            return this.calculateFieldForm(field, field.getCreationSubform(), namespace);
        }
        catch (Exception e) {
            log.error((Object)"Error: ", (Throwable)e);
            return null;
        }
    }

    public Form getPreviewDataForm(Field field, String namespace) {
        try {
            return this.calculateFieldForm(field, field.getPreviewSubform(), namespace);
        }
        catch (Exception e) {
            log.error((Object)"Error: ", (Throwable)e);
            return null;
        }
    }

    public Form getTableDataForm(Field field, String namespace) {
        try {
            return this.calculateFieldForm(field, field.getTableSubform(), namespace);
        }
        catch (Exception e) {
            log.error((Object)"Error: ", (Throwable)e);
            return null;
        }
    }

    public Form getEditForm(Field field, String namespace) {
        try {
            return this.calculateFieldForm(field, field.getEditionSubform(), namespace);
        }
        catch (Exception e) {
            log.error((Object)"Error: ", (Throwable)e);
            return null;
        }
    }
}

