/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formStatus;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormStatus
implements Serializable {
    private static transient Log log = LogFactory.getLog((String)FormStatus.class.getName());
    private Map inputValues = new InputValuesMap();
    private Map lastParameterMap;
    private Long relatedFormId;
    private Set wrongFields = new TreeSet();
    private Map<String, List> wrongFieldsMessages = new HashMap<String, List>();
    private String namespace;
    private Map attributes = new HashMap();

    public FormStatus(Long relatedFormId, String namespace) {
        this.relatedFormId = relatedFormId;
        this.namespace = namespace;
    }

    public Map getInputValues() {
        return this.inputValues;
    }

    public Map getLastParameterMap() {
        return this.lastParameterMap;
    }

    public void setLastParameterMap(Map lastParameterMap) {
        this.lastParameterMap = lastParameterMap;
    }

    public Set getWrongFields() {
        return this.wrongFields;
    }

    public Long getRelatedFormId() {
        return this.relatedFormId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    protected void clear() {
        this.inputValues.clear();
        this.attributes.clear();
        this.lastParameterMap = null;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public void clearFormErrors() {
        this.wrongFields.clear();
        this.wrongFieldsMessages.clear();
    }

    public void removeWrongField(String fieldName) {
        this.wrongFields.remove(fieldName);
        this.wrongFieldsMessages.remove(fieldName);
    }

    public List getErrorMessage(String fieldName) {
        return this.wrongFieldsMessages.get(fieldName);
    }

    public void addErrorMessages(String fieldName, List messages) {
        this.wrongFields.add(fieldName);
        this.wrongFieldsMessages.put(fieldName, messages);
    }

    public Map getWrongFieldsMessages() {
        return this.wrongFieldsMessages;
    }

    public void setWrongFieldsMessages(Map wrongFieldsMessages) {
        this.wrongFieldsMessages = wrongFieldsMessages;
    }

    class InputValuesMap
    extends HashMap {
        InputValuesMap() {
        }

        @Override
        public Object put(Object key, Object value) {
            Object obj = super.put(key, value);
            return obj;
        }

        @Override
        public void putAll(Map m) {
            super.putAll(m);
        }
    }
}

