/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formStatus;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.FieldHandlersManager;
import org.jbpm.formModeler.core.FormCoreServices;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.core.processing.FormProcessingServices;
import org.jbpm.formModeler.core.processing.formProcessing.NamespaceManager;
import org.jbpm.formModeler.core.processing.formStatus.FormStatus;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

@ApplicationScoped
public class FormStatusManager
implements Serializable {
    @Inject
    private Log log;
    private transient Map formStatuses = new Hashtable();

    public static FormStatusManager lookup() {
        return (FormStatusManager)CDIBeanLocator.getBeanByType(FormStatusManager.class);
    }

    public FormStatus getFormStatus(Long formId, String namespace) {
        namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
        return (FormStatus)this.formStatuses.get(namespace + "-" + formId);
    }

    public FormStatus createFormStatus(Long formId, String namespace) {
        namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
        FormStatus fs = new FormStatus(formId, namespace);
        this.formStatuses.put(namespace + "-" + formId, fs);
        try {
            Form form = FormCoreServices.lookup().getFormManager().getFormById(formId);
            FieldHandlersManager fieldHandlersManager = FormProcessingServices.lookup().getFieldHandlersManager();
            for (Field pff : form.getFormFields()) {
                FieldHandler handler = fieldHandlersManager.getHandler(pff.getFieldType());
                handler.initialize(pff, namespace);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error: ", (Throwable)e);
        }
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyFormStatus(Long formId, String namespace) {
        namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
        String requestedPreffix = namespace + "-" + formId;
        Map map = this.formStatuses;
        synchronized (map) {
            Iterator it = this.formStatuses.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!key.startsWith(requestedPreffix)) continue;
                it.remove();
            }
        }
    }

    public void cascadeClearWrongFields(Long formId, String namespace) {
        namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
        String requestedPreffix = namespace + "-" + formId;
        for (String key : this.formStatuses.keySet()) {
            if (!key.startsWith(requestedPreffix)) continue;
            FormStatus formStatus = (FormStatus)this.formStatuses.get(key);
            formStatus.clearFormErrors();
        }
    }

    public FormStatus getParent(FormStatus fs) {
        if (fs == null) {
            return null;
        }
        String namespace = fs.getNamespace();
        if (StringUtils.isEmpty((String)namespace)) {
            return null;
        }
        FormNamespaceData fsd = NamespaceManager.lookup().getNamespace(namespace);
        if (fsd == null) {
            return null;
        }
        return this.getFormStatus(fsd.getForm().getId(), fsd.getNamespace());
    }
}

