/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.jbpm.formModeler.api.client.FormRenderContext;
import org.jbpm.formModeler.api.client.FormRenderContextManager;
import org.jbpm.formModeler.api.model.DataHolder;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.api.model.wrappers.I18nSet;
import org.jbpm.formModeler.core.FieldHandlersManager;
import org.jbpm.formModeler.core.config.FormManagerImpl;
import org.jbpm.formModeler.core.config.RangeProviderManager;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormProcessor;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.PersistentFieldHandler;
import org.jbpm.formModeler.core.processing.ProcessingMessagedException;
import org.jbpm.formModeler.core.processing.fieldHandlers.NumericFieldHandler;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeResponse;
import org.jbpm.formModeler.core.processing.formProcessing.NamespaceManager;
import org.jbpm.formModeler.core.processing.formStatus.FormStatus;
import org.jbpm.formModeler.core.processing.formStatus.FormStatusManager;
import org.jbpm.formModeler.core.processing.impl.FormStatusDataImpl;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

@ApplicationScoped
public class FormProcessorImpl
implements FormProcessor,
Serializable {
    @Inject
    private Log log;
    private FormChangeProcessor formChangeProcessor;
    @Inject
    private RangeProviderManager rangeProviderManager;
    @Inject
    private FieldHandlersManager fieldHandlersManager;
    @Inject
    private FormRenderContextManager formRenderContextManager;

    protected FormStatus getContextFormStatus(FormRenderContext context) {
        return FormStatusManager.lookup().getFormStatus(context.getForm().getId(), context.getUID());
    }

    protected FormStatus getFormStatus(Form form, String namespace) {
        return this.getFormStatus(form, namespace, new HashMap());
    }

    protected FormStatus getFormStatus(Form form, String namespace, Map currentValues) {
        FormStatus formStatus = FormStatusManager.lookup().getFormStatus(form.getId(), namespace);
        return formStatus != null ? formStatus : this.createFormStatus(form, namespace, currentValues);
    }

    protected boolean existsFormStatus(Long formId, String namespace) {
        FormStatus formStatus = FormStatusManager.lookup().getFormStatus(formId, namespace);
        return formStatus != null;
    }

    protected FormStatus createFormStatus(Form form, String namespace, Map currentValues) {
        FormStatus fStatus = FormStatusManager.lookup().createFormStatus(form.getId(), namespace);
        this.setDefaultValues(form, namespace, currentValues);
        return fStatus;
    }

    protected void setDefaultValues(Form form, String namespace, Map currentValues) {
        if (form != null) {
            Set formFields = form.getFormFields();
            HashMap params = new HashMap(5);
            HashMap<String, Map> rangeFormulas = (HashMap<String, Map>)this.getAttribute(form, namespace, "-pot-rangeFormulas");
            if (rangeFormulas == null) {
                rangeFormulas = new HashMap<String, Map>();
                this.setAttribute(form, namespace, "-pot-rangeFormulas", rangeFormulas);
            }
            for (Field field : formFields) {
                Object value = currentValues.get(field.getFieldName());
                String inputName = this.getPrefix(form, namespace) + field.getFieldName();
                try {
                    String rangeFormula;
                    Map paramValue;
                    FieldHandler handler = this.fieldHandlersManager.getHandler(field.getFieldType());
                    if (value instanceof Map && !((Map)value).containsKey("-jbpm-formMode") && !(value instanceof I18nSet)) {
                        ((Map)value).put("-jbpm-formMode", currentValues.get("-jbpm-formMode"));
                    }
                    if ((paramValue = handler.getParamValue(inputName, value, field.getFieldPattern())) != null && !paramValue.isEmpty()) {
                        params.putAll(paramValue);
                    }
                    if ((rangeFormula = field.getRangeFormula()) == null || rangeFormula.trim().length() <= 0) continue;
                    rangeFormulas.put(field.getFieldName(), this.rangeProviderManager.getRangeValues(rangeFormula, namespace));
                }
                catch (Exception e) {
                    this.log.error((Object)("Error obtaining default values for " + inputName), (Throwable)e);
                }
            }
            this.setValues(form, namespace, params, null, true);
        }
    }

    protected void destroyFormStatus(Form form, String namespace) {
        FormStatusManager.lookup().destroyFormStatus(form.getId(), namespace);
    }

    public void setValues(Form form, String namespace, Map parameterMap, Map filesMap) {
        this.setValues(form, namespace, parameterMap, filesMap, false);
    }

    public void setValues(Form form, String namespace, Map parameterMap, Map filesMap, boolean incremental) {
        if (form != null) {
            namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
            FormStatus formStatus = this.getFormStatus(form, namespace);
            if (incremental) {
                HashMap mergedParameterMap = new HashMap();
                if (formStatus.getLastParameterMap() != null) {
                    mergedParameterMap.putAll(formStatus.getLastParameterMap());
                }
                if (parameterMap != null) {
                    mergedParameterMap.putAll(parameterMap);
                }
                formStatus.setLastParameterMap(mergedParameterMap);
            } else {
                formStatus.setLastParameterMap(parameterMap);
            }
            String inputsPrefix = this.getPrefix(form, namespace);
            for (Field field : form.getFormFields()) {
                this.setFieldValue(field, formStatus, inputsPrefix, parameterMap, filesMap, incremental);
            }
        }
    }

    public void modify(Form form, String namespace, String fieldName, Object value) {
        FormStatus formStatus = this.getFormStatus(form, namespace);
        formStatus.getInputValues().put(fieldName, value);
        this.propagateChangesToParentFormStatuses(formStatus, fieldName, value);
    }

    public void setAttribute(Form form, String namespace, String attributeName, Object attributeValue) {
        if (form != null) {
            FormStatus formStatus = this.getFormStatus(form, namespace);
            formStatus.getAttributes().put(attributeName, attributeValue);
        }
    }

    public Object getAttribute(Form form, String namespace, String attributeName) {
        if (form != null) {
            FormStatus formStatus = this.getFormStatus(form, namespace);
            return formStatus.getAttributes().get(attributeName);
        }
        return null;
    }

    protected void setFieldValue(Field field, FormStatus formStatus, String inputsPrefix, Map parameterMap, Map filesMap, boolean incremental) {
        block12: {
            String fieldName = field.getFieldName();
            String inputName = inputsPrefix + fieldName;
            FieldHandler handler = this.fieldHandlersManager.getHandler(field.getFieldType());
            try {
                Object previousValue = formStatus.getInputValues().get(fieldName);
                boolean isRequired = field.getFieldRequired();
                if (!(handler.isEvaluable(inputName, parameterMap, filesMap) || handler.isEmpty(previousValue) && isRequired)) {
                    return;
                }
                Object value = null;
                boolean emptyNumber = false;
                try {
                    value = handler.getValue(field, inputName, parameterMap, filesMap, field.getFieldType().getFieldClass(), previousValue);
                }
                catch (NumericFieldHandler.EmptyNumberException ene) {
                    emptyNumber = true;
                }
                if (incremental && value == null && !emptyNumber) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Refusing to overwrite input value for parameter " + fieldName));
                    }
                    break block12;
                }
                formStatus.getInputValues().put(fieldName, value);
                try {
                    this.propagateChangesToParentFormStatuses(formStatus, fieldName, value);
                }
                catch (Exception e) {
                    this.log.error((Object)"Error modifying formStatus: ", (Throwable)e);
                }
                boolean isEmpty = handler.isEmpty(value);
                if (isRequired && isEmpty && !incremental) {
                    this.log.debug((Object)("Missing required field " + fieldName));
                    formStatus.getWrongFields().add(fieldName);
                } else {
                    formStatus.removeWrongField(fieldName);
                }
            }
            catch (ProcessingMessagedException pme) {
                this.log.debug((Object)"Processing field: ", (Throwable)pme);
                formStatus.addErrorMessages(fieldName, pme.getMessages());
            }
            catch (Exception e) {
                this.log.debug((Object)"Error setting field value:", (Throwable)e);
                if (incremental) break block12;
                formStatus.getInputValues().put(fieldName, null);
                formStatus.getWrongFields().add(fieldName);
            }
        }
    }

    protected void propagateChangesToParentFormStatuses(FormStatus formStatus, String fieldName, Object value) {
        FormStatus parent = FormStatusManager.lookup().getParent(formStatus);
        if (parent != null) {
            String fieldNameInParent = NamespaceManager.lookup().getNamespace(formStatus.getNamespace()).getFieldNameInParent();
            Object valueInParent = parent.getInputValues().get(fieldNameInParent);
            if (valueInParent != null) {
                Integer pos;
                Map editFieldPositions;
                Map parentMapObjectRepresentation = null;
                if (valueInParent instanceof Map) {
                    parentMapObjectRepresentation = (Map)valueInParent;
                } else if (valueInParent instanceof Map[] && (editFieldPositions = (Map)parent.getAttributes().get("-pot-editFieldPositions")) != null && (pos = (Integer)editFieldPositions.get(fieldNameInParent)) != null) {
                    parentMapObjectRepresentation = ((Map[])valueInParent)[pos];
                }
                if (parentMapObjectRepresentation != null) {
                    parentMapObjectRepresentation.put(fieldName, value);
                    this.propagateChangesToParentFormStatuses(parent, fieldNameInParent, valueInParent);
                }
            }
        }
    }

    public FormStatusData read(String ctxUid) {
        FormStatusDataImpl data = null;
        try {
            boolean isNew;
            FormRenderContext context = this.formRenderContextManager.getFormRenderContext(ctxUid);
            if (context == null) {
                return null;
            }
            FormStatus formStatus = this.getContextFormStatus(context);
            boolean bl = isNew = formStatus == null;
            if (isNew) {
                formStatus = this.createContextFormStatus(context);
            }
            data = new FormStatusDataImpl(formStatus, isNew);
        }
        catch (Exception e) {
            this.log.error((Object)"Error: ", (Throwable)e);
        }
        return data;
    }

    protected Object readSimpleBindingValue(Form form, Field field, String bindingExpression, Map<String, Object> bindingData) {
        DataHolder holder = form.getDataHolderByField(field);
        if (holder != null) {
            Object bindingValue = bindingData.get(holder.getInputId());
            try {
                if (bindingValue != null && holder.isAssignableValue(bindingValue)) {
                    return holder.readFromBindingExperssion(bindingValue, bindingExpression);
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Unable to read value from expression '" + bindingExpression + "'. Error: "), (Throwable)e);
            }
        } else if ((bindingExpression = bindingExpression.substring(1, bindingExpression.length() - 1)).indexOf("/") != -1) {
            try {
                String root = bindingExpression.substring(0, bindingExpression.indexOf("/"));
                String expression = bindingExpression.substring(root.length() + 1);
                Object object = bindingData.get(root);
                JXPathContext ctx = JXPathContext.newContext((Object)object);
                return ctx.getValue(expression);
            }
            catch (Exception e) {
                this.log.warn((Object)("Error getting value for xpath xpression '" + bindingExpression + "' :"), (Throwable)e);
            }
        }
        return bindingData.get(bindingExpression);
    }

    protected FormStatus createContextFormStatus(FormRenderContext context) throws Exception {
        Form form;
        Set fields;
        HashMap<String, Object> values = new HashMap<String, Object>();
        Map inputData = context.getInputData();
        Map outputData = context.getOutputData();
        if (inputData != null && !inputData.isEmpty() && (fields = (form = context.getForm()).getFormFields()) != null) {
            for (Field field : form.getFormFields()) {
                boolean hasOutput;
                String inputBinding = field.getInputBinding();
                String outputBinding = field.getOutputBinding();
                boolean hasInput = !StringUtils.isEmpty((String)inputBinding);
                boolean bl = hasOutput = !StringUtils.isEmpty((String)outputBinding);
                if (!hasInput && !hasOutput) continue;
                Object value = null;
                if (!hasOutput) {
                    value = this.readSimpleBindingValue(form, field, inputBinding, inputData);
                } else if (!hasInput) {
                    value = this.readSimpleBindingValue(form, field, outputBinding, outputData);
                } else {
                    boolean complexBinding;
                    inputBinding = inputBinding.substring(1, inputBinding.length() - 1);
                    outputBinding = outputBinding.substring(1, outputBinding.length() - 1);
                    String[] inputParts = inputBinding.split("/");
                    String[] outputParts = outputBinding.split("/");
                    boolean bl2 = complexBinding = inputParts.length == 2 && outputParts.length == 2;
                    if (complexBinding) {
                        DataHolder holder = form.getDataHolderByIds(inputParts[0], outputParts[0]);
                        if (holder != null) {
                            Object inputValue = inputData.get(holder.getInputId());
                            Object outputValue = outputData.get(holder.getOuputId());
                            if (inputValue == null && outputValue == null) continue;
                            if (outputValue != null && holder.isAssignableValue(outputValue)) {
                                value = holder.readValue(outputValue, outputParts[1]);
                            } else if (inputValue != null && holder.isAssignableValue(inputValue)) {
                                value = holder.readValue(inputValue, inputParts[1]);
                            }
                        } else {
                            try {
                                Object object = inputData.get(inputParts[0]);
                                JXPathContext ctx = JXPathContext.newContext(object);
                                value = ctx.getValue(inputParts[2]);
                            }
                            catch (Exception e) {
                                this.log.warn((Object)("Error getting value for xpath xpression '" + inputBinding + "' :"), (Throwable)e);
                            }
                        }
                    } else {
                        value = outputData.containsKey(outputBinding) ? outputData.get(outputBinding) : inputData.get(inputBinding);
                    }
                }
                values.put(field.getFieldName(), value);
            }
        }
        return this.getFormStatus(context.getForm(), context.getUID(), values);
    }

    public FormStatusData read(Form form, String namespace, Map currentValues) {
        boolean exists = this.existsFormStatus(form.getId(), namespace);
        if (currentValues == null) {
            currentValues = new HashMap();
        }
        FormStatus formStatus = this.getFormStatus(form, namespace, currentValues);
        FormStatusDataImpl data = null;
        try {
            data = new FormStatusDataImpl(formStatus, !exists);
        }
        catch (Exception e) {
            this.log.error((Object)"Error: ", (Throwable)e);
        }
        return data;
    }

    public FormStatusData read(Form form, String namespace) {
        return this.read(form, namespace, new HashMap());
    }

    public void flushPendingCalculations(Form form, String namespace) {
        if (this.formChangeProcessor != null) {
            this.formChangeProcessor.process(form, namespace, new FormChangeResponse());
        }
    }

    public void persist(String ctxUid) throws Exception {
        ctxUid = StringUtils.defaultIfEmpty((String)ctxUid, (String)"NS");
        this.persist(this.formRenderContextManager.getFormRenderContext(ctxUid));
    }

    public void persist(FormRenderContext context) throws Exception {
        Form form = context.getForm();
        Map mapToPersist = this.getFilteredMapRepresentationToPersist(form, context.getUID());
        Map result = context.getOutputData();
        for (String fieldName : mapToPersist.keySet()) {
            boolean simpleBinding;
            Field field = form.getField(fieldName);
            if (field == null) continue;
            DataHolder holder = form.getDataHolderByField(field);
            String bindingString = field.getOutputBinding();
            if (StringUtils.isEmpty((String)bindingString)) continue;
            Object value = this.persistField(field, mapToPersist, holder, context.getUID());
            boolean bl = simpleBinding = StringUtils.isEmpty((String)(bindingString = bindingString.substring(1, bindingString.length() - 1))) || bindingString.indexOf("/") == -1;
            if (holder == null || simpleBinding) {
                result.put(bindingString, value);
                continue;
            }
            String holderFieldId = bindingString.substring((holder.getOuputId() + "/").length());
            Object holderOutputValue = result.get(holder.getOuputId());
            if (holderOutputValue == null) {
                holderOutputValue = holder.createInstance(context);
                result.put(holder.getOuputId(), holderOutputValue);
            }
            holder.writeValue(holderOutputValue, holderFieldId, value);
        }
    }

    public Object persistFormHolder(Form form, String namespace, Map<String, Object> mapToPersist, DataHolder holder) throws Exception {
        if (holder == null) {
            return null;
        }
        FormRenderContext context = this.formRenderContextManager.getRootContext(namespace);
        Object result = holder.createInstance(context);
        for (String fieldName : mapToPersist.keySet()) {
            String bindingString;
            Field field = form.getField(fieldName);
            if (field == null || !holder.isAssignableForField(field) || StringUtils.isEmpty((String)(bindingString = field.getOutputBinding()))) continue;
            bindingString = bindingString.substring(1, bindingString.length() - 1);
            String holderFieldId = bindingString.substring(holder.getOuputId().length() + 1);
            Object value = this.persistField(field, mapToPersist, holder, namespace);
            holder.writeValue(result, holderFieldId, value);
        }
        return result;
    }

    protected Object persistField(Field field, Map<String, Object> mapToPersist, DataHolder holder, String namespace) throws Exception {
        boolean complexBinding;
        String bindingString = field.getOutputBinding();
        if (holder == null && !StringUtils.isEmpty((String)bindingString)) {
            return mapToPersist.get(field.getFieldName());
        }
        boolean bl = complexBinding = (bindingString = bindingString.substring(1, bindingString.length() - 1)).indexOf("/") > 0;
        if (complexBinding) {
            String holderId = bindingString.substring(0, bindingString.indexOf("/"));
            String holderFieldId = bindingString.substring(holderId.length() + 1);
            if (holder != null && !StringUtils.isEmpty((String)holderFieldId)) {
                FieldHandler handler = (FieldHandler)CDIBeanLocator.getBeanByNameOrType((String)field.getFieldType().getManagerClass());
                if (handler instanceof PersistentFieldHandler) {
                    String inputName = this.getPrefix(field.getForm(), namespace) + field.getFieldName();
                    return ((PersistentFieldHandler)handler).persist(field, inputName, holder.getInfo());
                }
                return mapToPersist.get(field.getFieldName());
            }
        }
        return mapToPersist.get(field.getFieldName());
    }

    public Map getMapRepresentationToPersist(Form form, String namespace) throws Exception {
        namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
        this.flushPendingCalculations(form, namespace);
        HashMap m = new HashMap();
        FormStatus formStatus = this.getFormStatus(form, namespace);
        if (!formStatus.getWrongFields().isEmpty()) {
            throw new IllegalArgumentException("Validation error.");
        }
        this.fillObjectValues(m, formStatus.getInputValues(), form);
        TreeSet s = (TreeSet)m.get("-jbpm-modifiedFieldNames");
        if (s == null) {
            s = new TreeSet();
            m.put("-jbpm-modifiedFieldNames", s);
        }
        s.addAll(form.getFieldNames());
        return m;
    }

    protected Map getFilteredMapRepresentationToPersist(Form form, String namespace) throws Exception {
        Map inputValues = this.getMapRepresentationToPersist(form, namespace);
        Map mapToPersist = this.filterMapRepresentationToPersist(inputValues);
        return mapToPersist;
    }

    public Map filterMapRepresentationToPersist(Map inputValues) throws Exception {
        HashMap filteredMap = new HashMap();
        Set keys = inputValues.keySet();
        for (String key : keys) {
            filteredMap.put(key, inputValues.get(key));
        }
        return filteredMap;
    }

    protected void fillObjectValues(Map obj, Map values, Form form) throws Exception {
        HashMap valuesToSet = new HashMap();
        for (String propertyName : values.keySet()) {
            Object propertyValue = values.get(propertyName);
            valuesToSet.put(propertyName, propertyValue);
        }
        obj.putAll(valuesToSet);
    }

    protected FormManagerImpl getFormsManager() {
        return (FormManagerImpl)CDIBeanLocator.getBeanByType(FormManagerImpl.class);
    }

    public void clear(FormRenderContext context) {
        this.clear(context.getForm(), context.getUID());
    }

    public void clear(String ctxUID) {
        this.clear(this.formRenderContextManager.getFormRenderContext(ctxUID));
    }

    public void clear(Form form, String namespace) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Clearing form status for form " + form.getName() + " with namespace '" + namespace + "'"));
        }
        this.destroyFormStatus(form, namespace);
    }

    public void clearField(Form form, String namespace, String fieldName) {
        FormStatus formStatus = this.getFormStatus(form, namespace);
        formStatus.getInputValues().remove(fieldName);
    }

    public void clearFieldErrors(Form form, String namespace) {
        FormStatusManager.lookup().cascadeClearWrongFields(form.getId(), namespace);
    }

    public void forceWrongField(Form form, String namespace, String fieldName) {
        FormStatusManager.lookup().getFormStatus(form.getId(), namespace).getWrongFields().add(fieldName);
    }

    protected String getPrefix(Form form, String namespace) {
        return namespace + "-" + form.getId() + "-";
    }
}

