/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing;

import java.util.Collection;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.formProcessing.BasicFormChangeProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeResponse;

@ApplicationScoped
public class FormulasCalculatorChangeProcessor
extends BasicFormChangeProcessor {
    private static transient Log log = LogFactory.getLog((String)FormulasCalculatorChangeProcessor.class.getName());

    @Override
    public FormChangeResponse doProcess(FormChangeResponse response) {
        try {
            Form form = this.context.getForm();
            if (form == null) {
                log.warn((Object)("Form object is not present in current FormProcessingContext, formula evaluation will be canceled. context: " + this.context));
                return response;
            }
            Object loadedObject = null;
            FormStatusData statusData = this.formProcessor.read(form, this.context.getNamespace());
            Collection fieldNames = this.getEvaluableFields();
            this.evaluatedFields.clear();
            for (String fieldName : fieldNames) {
                Field field = form.getField(fieldName);
                this.evaluateFormulaForField(form, this.context.getNamespace(), field, loadedObject, statusData, response, new Date());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error: ", (Throwable)e);
        }
        return response;
    }

    @Override
    public int getSupportedContextType() {
        return 1;
    }
}

