/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.core.rendering.SubformFinderService;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

@ApplicationScoped
public class NamespaceManager {
    @Inject
    private SubformFinderService subformFinderService;
    @Inject
    private Log log;

    public static NamespaceManager lookup() {
        return (NamespaceManager)CDIBeanLocator.getBeanByType(NamespaceManager.class);
    }

    public String getParentNamespace(String namespace) {
        int lastIndex;
        int previousLastIndex;
        if (namespace != null && (previousLastIndex = namespace.lastIndexOf("-", (lastIndex = namespace.lastIndexOf("-")) - 1)) != -1) {
            String parentNamespace = namespace.substring(0, previousLastIndex);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Parent namespace for '" + namespace + "' is '" + parentNamespace + "'"));
            }
            return parentNamespace;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Parent namespace for '" + namespace + "' is empty string"));
        }
        return "";
    }

    public FormNamespaceData getNamespace(String fieldName) {
        int lastIndex;
        int previousLastIndex;
        if (fieldName != null && (previousLastIndex = fieldName.lastIndexOf("-", (lastIndex = fieldName.lastIndexOf("-")) - 1)) != -1) {
            String formIdString = fieldName.substring(previousLastIndex + 1, lastIndex);
            String namespace = fieldName.substring(0, previousLastIndex);
            String fieldNameInParent = fieldName.substring(lastIndex + 1, fieldName.length());
            if (!"_".equals(formIdString)) {
                Long formId = Long.decode(formIdString);
                try {
                    Form form = this.subformFinderService.getFormById(formId.longValue(), namespace);
                    return new FormNamespaceData(form, namespace, fieldNameInParent);
                }
                catch (Exception e) {
                    this.log.error((Object)"Error: ", (Throwable)e);
                }
            }
        }
        return null;
    }
}

