/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing.replacers;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.core.rendering.SubformFinderService;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

public class FormulaReplacementContext {
    private static transient Log log = LogFactory.getLog((String)FormulaReplacementContext.class.getName());
    private String formula;
    private String paramValue;
    private Field field;
    private String namespace;
    private Date date;
    private boolean beforeFieldEvaluation;
    private Map item;

    public FormulaReplacementContext() {
    }

    public FormulaReplacementContext(boolean beforeFieldEvaluation, Date date, Field field, String formula, String namespace, String paramValue) {
        this.beforeFieldEvaluation = beforeFieldEvaluation;
        this.date = date;
        this.field = field;
        this.formula = formula;
        this.namespace = namespace;
        this.paramValue = paramValue;
    }

    public FormulaReplacementContext(FormulaReplacementContext ctx) {
        this(ctx.isBeforeFieldEvaluation(), ctx.getDate(), ctx.getField(), ctx.getFormula(), ctx.getNamespace(), ctx.getParamValue());
    }

    public boolean isBeforeFieldEvaluation() {
        return this.beforeFieldEvaluation;
    }

    public void setBeforeFieldEvaluation(boolean beforeFieldEvaluation) {
        this.beforeFieldEvaluation = beforeFieldEvaluation;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }

    public String getFieldInputName() {
        return new StringBuffer().append(this.namespace).append("-").append(this.field.getForm().getId()).append("-").append(this.field.getFieldName()).toString();
    }

    public Map getItem() {
        return this.item;
    }

    public void setItem(Map item) {
        this.item = item;
    }

    public FormulaReplacementContext getParentContext() {
        try {
            if (this.namespace.indexOf("-") == -1) {
                return null;
            }
            String fieldName = this.namespace.substring(this.namespace.lastIndexOf("-"));
            String parentNamespace = this.namespace.substring(0, this.namespace.lastIndexOf(fieldName));
            String formId = parentNamespace.substring(parentNamespace.lastIndexOf("-") + 1);
            parentNamespace = parentNamespace.substring(0, parentNamespace.lastIndexOf("-"));
            FormulaReplacementContext parent = new FormulaReplacementContext();
            SubformFinderService subformFinderService = (SubformFinderService)CDIBeanLocator.getBeanByType(SubformFinderService.class);
            if ((fieldName = fieldName.substring(1)).indexOf(".") != -1) {
                fieldName = fieldName.substring(0, fieldName.lastIndexOf("."));
            }
            parent.setNamespace(parentNamespace);
            parent.setField(subformFinderService.getFormById(Long.decode(formId).longValue(), parentNamespace).getField(fieldName));
            parent.setBeforeFieldEvaluation(this.beforeFieldEvaluation);
            parent.setDate(this.getDate());
            parent.setFormula(null);
            parent.setParamValue(null);
            return parent;
        }
        catch (Exception e) {
            log.error((Object)"Error getting field parent: ", (Throwable)e);
            return null;
        }
    }

    public void populate(Interpreter interpreter) throws EvalError {
        if (this.item != null) {
            interpreter.set("item", (Object)this.item);
        }
        interpreter.set("ctx", (Object)this);
    }
}

