/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formRendering;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.jbpm.formModeler.core.processing.formRendering.FormTemplateHelper;
import org.jbpm.formModeler.core.processing.formRendering.HTMLPieceRenderingInstruction;
import org.jbpm.formModeler.core.processing.formRendering.RenderFieldInstruction;
import org.jbpm.formModeler.core.processing.formRendering.RenderLabelInstruction;
import org.jbpm.formModeler.core.processing.formRendering.TemplateRenderingInstruction;

@ApplicationScoped
public class FormTemplateHelperImpl
implements FormTemplateHelper {
    public static final MessageFormat fieldMsgFormat = new MessageFormat("{0}$field'{'{1}'}'{2}");
    public static final MessageFormat labelMsgFormat = new MessageFormat("{0}$label'{'{1}'}'{2}");
    private Hashtable templatesCache = new Hashtable();

    public synchronized List getRenderingInstructions(String template) {
        if (template == null) {
            return Collections.EMPTY_LIST;
        }
        List l = (List)this.templatesCache.get(template);
        if (l == null) {
            l = this.calculateInstructions(template);
            if (this.templatesCache.size() > 50) {
                this.templatesCache.remove(this.templatesCache.keySet().iterator().next());
            }
            this.templatesCache.put(template, l);
        }
        return l;
    }

    protected synchronized List calculateInstructions(String template) {
        if (template == null || "".equals(template.trim())) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<TemplateRenderingInstruction> result = new ArrayList<TemplateRenderingInstruction>();
        Object[] parsedResult = this.splitByElement(template, fieldMsgFormat);
        if (parsedResult == null) {
            Object[] parsedResult2 = this.splitByElement(template, labelMsgFormat);
            if (parsedResult2 == null) {
                result.add(new HTMLPieceRenderingInstruction(template));
            } else {
                result.add(new HTMLPieceRenderingInstruction((String)parsedResult2[0]));
                result.add(new RenderLabelInstruction((String)parsedResult2[1]));
                result.addAll(this.calculateInstructions((String)parsedResult2[2]));
            }
        } else {
            result.addAll(this.calculateInstructions((String)parsedResult[0]));
            result.add(new RenderFieldInstruction((String)parsedResult[1]));
            result.addAll(this.calculateInstructions((String)parsedResult[2]));
        }
        return result;
    }

    protected synchronized Object[] splitByElement(String template, MessageFormat s) {
        try {
            return s.parse(template);
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

