/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.wrappers.I18nEntry;
import org.jbpm.formModeler.core.processing.DefaultFieldHandler;
import org.jbpm.formModeler.core.wrappers.HTMLi18n;
import org.jbpm.formModeler.service.LocaleManager;

@ApplicationScoped
public class HTMLi18nFieldHandler
extends DefaultFieldHandler {
    public static final String DIV_INPUT_NAME_PREFFIX = "Div__";

    public String[] getCompatibleClassNames() {
        return new String[]{HTMLi18n.class.getName()};
    }

    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        String[] locales;
        HTMLi18n set = new HTMLi18n();
        for (String locale : locales = LocaleManager.lookup().getInstalledLocaleIds()) {
            String[] value = (String[])parametersMap.get(inputName + "_" + locale);
            if (value != null && value.length > 0) {
                set.setValue(locale, value[0]);
                continue;
            }
            set.setValue(locale, "");
        }
        return set.isEmpty() ? null : set;
    }

    public Map getParamValue(String inputName, Object objectValue, String pattern) {
        if (objectValue == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        HTMLi18n value = (HTMLi18n)objectValue;
        for (I18nEntry entry : value) {
            m.put(inputName + "_" + entry.getLang(), new String[]{(String)entry.getValue()});
        }
        m.put(inputName, new String[0]);
        return m;
    }

    public boolean isEmpty(Object value) {
        if (value == null || ((HTMLi18n)value).isEmpty()) {
            return true;
        }
        for (I18nEntry entry : (HTMLi18n)value) {
            if (entry.getValue() == null || "".equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean acceptsPropertyName(String propName) {
        return true;
    }
}

