/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.model.Form;

public class FormProcessingContext {
    public static final int TYPE_FULL = 0;
    public static final int TYPE_FORMULA = 1;
    public static final int TYPE_RANGE = 2;
    public static final int TYPE_STYLE = 3;
    private int type;
    private Form form;
    private String namespace;
    private String formMode;
    private List<String> fieldsToEvaluateFormula;
    private List<String> fieldsToEvaluateRange;
    private List<String> fieldsToEvaluateStyle;

    public static FormProcessingContext fullProcessingContext(Form form, String namespace, String formMode) {
        return new FormProcessingContext(0, form, namespace, formMode, null);
    }

    public static FormProcessingContext formulaProcessingContext(Form form, String namespace, String formMode, List<String> fieldsToEvaluateFormula) {
        return new FormProcessingContext(1, form, namespace, formMode, fieldsToEvaluateFormula);
    }

    public static FormProcessingContext rangeProcessingContext(Form form, String namespace, String formMode, List<String> fieldsToEvaluateRange) {
        return new FormProcessingContext(2, form, namespace, formMode, fieldsToEvaluateRange);
    }

    public static FormProcessingContext styleProcessingContext(Form form, String namespace, String formMode, List<String> fieldsToEvaluateStyle) {
        return new FormProcessingContext(3, form, namespace, formMode, fieldsToEvaluateStyle);
    }

    private FormProcessingContext(int type, Form form, String namespace, String formMode, List<String> fieldsToEvaluate) {
        this.type = type;
        this.form = form;
        this.namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
        this.formMode = StringUtils.defaultString((String)formMode);
        switch (type) {
            case 1: {
                this.fieldsToEvaluateFormula = fieldsToEvaluate;
                break;
            }
            case 2: {
                this.fieldsToEvaluateRange = fieldsToEvaluate;
                break;
            }
            case 3: {
                this.fieldsToEvaluateStyle = fieldsToEvaluate;
            }
        }
    }

    public List<String> getFieldsToEvaluateStyle() {
        return this.fieldsToEvaluateStyle;
    }

    public void setFieldsToEvaluateStyle(List<String> fieldsToEvaluateStyle) {
        this.fieldsToEvaluateStyle = fieldsToEvaluateStyle;
    }

    public List<String> getFieldsToEvaluateFormula() {
        return this.fieldsToEvaluateFormula;
    }

    public void setFieldsToEvaluateFormula(List<String> fieldsToEvaluateFormula) {
        this.fieldsToEvaluateFormula = fieldsToEvaluateFormula;
    }

    public List getFieldsToEvaluateRange() {
        return this.fieldsToEvaluateRange;
    }

    public Form getForm() {
        return this.form;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getFormMode() {
        return this.formMode;
    }

    public int getType() {
        return this.type;
    }

    public boolean isFull() {
        return 0 == this.type;
    }

    public boolean isFormula() {
        return 1 == this.type;
    }

    public boolean isRange() {
        return 2 == this.type;
    }
}

