/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.core.processing.FieldHandler;

public abstract class AbstractFieldHandler
implements FieldHandler {
    public String getHumanName(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle("org.jbpm.formModeler.core.processing.fieldHandlers", locale);
        try {
            return bundle.getString(this.getName());
        }
        catch (Exception e) {
            return this.getName();
        }
    }

    public void initialize(Field field, String namespace) {
    }

    public boolean isEvaluable(String inputName, Map parametersMap, Map filesMap) {
        return true;
    }

    protected boolean checkBooleanParameter(String[] param) {
        return param != null && param.length > 0 && Boolean.valueOf(StringUtils.defaultString((String)param[0])) != false;
    }

    protected String getFieldName() {
        String name = this.getClass().getSimpleName();
        return name.substring(0, name.indexOf("FieldHandler"));
    }

    public String getPageToIncludeForRendering() {
        return "/formModeler/fieldHandlers/" + this.getFieldName() + "/input.jsp";
    }

    public String getPageToIncludeForDisplaying() {
        return "/formModeler/fieldHandlers/" + this.getFieldName() + "/show.jsp";
    }

    public String getPageToIncludeForSearching() {
        return "/formModeler/fieldHandlers/" + this.getFieldName() + "/search.jsp";
    }
}

