/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.core.processing.DefaultFieldHandler;
import org.jbpm.formModeler.service.LocaleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="org.jbpm.formModeler.core.processing.fieldHandlers.NumericFieldHandler")
public class NumericFieldHandler
extends DefaultFieldHandler {
    public static final String NUMERIC_FROM_SUFFIX = "_from";
    public static final String NUMERIC_TO_SUFFIX = "_to";
    public static final boolean DEFAULT_MAX_VALUE = true;
    private static transient Logger log = LoggerFactory.getLogger(NumericFieldHandler.class);

    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        String[] numberFrom = (String[])parametersMap.get(inputName + NUMERIC_FROM_SUFFIX);
        String[] numberTo = (String[])parametersMap.get(inputName + NUMERIC_TO_SUFFIX);
        if (numberFrom != null || numberTo != null) {
            Object from = null;
            try {
                from = this.getTheValue(field, numberFrom, desiredClassName);
            }
            catch (EmptyNumberException e) {
                // empty catch block
            }
            Object to = null;
            try {
                to = this.getTheValue(field, numberTo, desiredClassName);
            }
            catch (Exception e) {
                // empty catch block
            }
            return new Object[]{from, to};
        }
        String[] paramValue = (String[])parametersMap.get(inputName);
        return this.getTheValue(field, paramValue, desiredClassName);
    }

    public Object getTheValue(Field field, String[] paramValue, String desiredClassName) throws Exception {
        if (paramValue == null || paramValue.length == 0) {
            return null;
        }
        if (desiredClassName.equals(Short.class.getName())) {
            if (StringUtils.isEmpty((String)paramValue[0])) {
                throw new EmptyNumberException();
            }
            return Short.decode(paramValue[0]);
        }
        if (desiredClassName.equals(Integer.class.getName())) {
            if (StringUtils.isEmpty((String)paramValue[0])) {
                throw new EmptyNumberException();
            }
            return Integer.decode(paramValue[0]);
        }
        if (desiredClassName.equals(Long.class.getName())) {
            if (StringUtils.isEmpty((String)paramValue[0])) {
                throw new EmptyNumberException();
            }
            return Long.decode(paramValue[0]);
        }
        if (desiredClassName.equals(Double.class.getName()) || desiredClassName.equals(Float.class.getName()) || desiredClassName.equals(BigDecimal.class.getName())) {
            String pattern;
            if (StringUtils.isEmpty((String)paramValue[0])) {
                throw new EmptyNumberException();
            }
            DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(new Locale(LocaleManager.currentLang()));
            if (desiredClassName.equals(BigDecimal.class.getName())) {
                df.setParseBigDecimal(true);
            }
            if ((pattern = field.getFieldPattern()) != null && !"".equals(pattern)) {
                df.applyPattern(pattern);
            } else {
                df.applyPattern("###.##");
            }
            ParsePosition pp = new ParsePosition(0);
            Number num = df.parse(paramValue[0], pp);
            if (paramValue[0].length() != pp.getIndex() || num == null) {
                log.debug("Error on parsing value");
                throw new ParseException("Error parsing value", pp.getIndex());
            }
            if (desiredClassName.equals(BigDecimal.class.getName())) {
                return num;
            }
            if (desiredClassName.equals(Float.class.getName())) {
                return new Float(num.floatValue());
            }
            return new Double(num.doubleValue());
        }
        if (desiredClassName.equals(BigInteger.class.getName())) {
            if (StringUtils.isEmpty((String)paramValue[0])) {
                throw new EmptyNumberException();
            }
            return new BigInteger(paramValue[0]);
        }
        throw new IllegalArgumentException("Invalid class for NumericFieldHandler: " + desiredClassName);
    }

    public Map getParamValue(String inputName, Object objectValue, String pattern) {
        if (objectValue == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        if (objectValue.getClass().isArray()) {
            Object[] values = (Object[])objectValue;
            if (values.length > 0 && values[0] != null) {
                m.put(inputName + NUMERIC_FROM_SUFFIX, this.buildParamValue(values[0], pattern));
            }
            if (values.length > 1 && values[1] != null) {
                m.put(inputName + NUMERIC_TO_SUFFIX, this.buildParamValue(values[1], pattern));
            }
        } else {
            m.put(inputName, this.buildParamValue(objectValue, pattern));
        }
        return m;
    }

    protected String[] buildParamValue(Object value, String pattern) {
        String[] result = null;
        if (value != null && Arrays.asList(this.getCompatibleClassNames()).contains(value.getClass().getName())) {
            if (pattern != null && !"".equals(pattern)) {
                try {
                    DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(new Locale(LocaleManager.currentLang()));
                    if (value instanceof BigDecimal) {
                        df.setParseBigDecimal(true);
                    }
                    df.applyPattern(pattern);
                    value = value instanceof Float ? df.format(((Float)value).floatValue()) : (value instanceof BigDecimal ? df.format(value) : df.format((Double)value));
                }
                catch (Exception e) {
                    if (value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
                        return this.buildParamValue(value, null);
                    }
                    return result;
                }
            }
            result = new String[]{value.toString()};
        }
        return result;
    }

    public boolean acceptsPropertyName(String propName) {
        return true;
    }

    public String[] getCompatibleClassNames() {
        return new String[]{String.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName()};
    }

    public boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                Object _value = values[i];
                if (_value == null) continue;
                return false;
            }
            return true;
        }
        return value != null && "".equals(value);
    }

    public class EmptyNumberException
    extends Exception {
    }
}

