/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.components.renderer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.formModeler.api.client.FormRenderContext;
import org.jbpm.formModeler.api.client.FormRenderContextManager;
import org.jbpm.formModeler.api.events.FormSubmitFailEvent;
import org.jbpm.formModeler.api.events.FormSubmittedEvent;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.components.renderer.ContextRemovedEvent;
import org.jbpm.formModeler.components.renderer.ContextRenderedEvent;
import org.jbpm.formModeler.core.processing.FormProcessor;

@SessionScoped
public class FormRenderContextManagerImpl
implements FormRenderContextManager,
Serializable {
    @Inject
    private FormProcessor formProcessor;
    @Inject
    private Event<FormSubmitFailEvent> formSubmitFailEvent;
    @Inject
    private Event<FormSubmittedEvent> formSubmittedEvent;
    @Inject
    private Event<ContextRemovedEvent> contextRemovedEventEvent;
    protected Map<String, FormRenderContext> formRenderContextMap = new HashMap<String, FormRenderContext>();
    protected List<String> contextToRemove = new ArrayList<String>();

    public void persistContext(FormRenderContext ctx) throws Exception {
        if (ctx == null) {
            throw new IllegalArgumentException("Unable to persist null context");
        }
        this.formProcessor.persist(ctx);
    }

    public void persistContext(String ctxUID) throws Exception {
        this.persistContext(this.getFormRenderContext(ctxUID));
    }

    public void removeContext(String ctxUID) {
        this.removeContext(this.getFormRenderContext(ctxUID));
    }

    public void removeContext(FormRenderContext context) {
        if (context != null) {
            if (!context.isInUse()) {
                this.doRemovecontext(context.getUID());
            } else {
                this.contextToRemove.add(context.getUID());
            }
        }
    }

    protected void doRemovecontext(String ctxUID) {
        FormRenderContext context = this.formRenderContextMap.get(ctxUID);
        if (context == null) {
            return;
        }
        context.clear();
        this.contextToRemove.remove(ctxUID);
        this.formProcessor.clear(context);
        this.formRenderContextMap.remove(context.getUID());
        this.contextRemovedEventEvent.fire((Object)new ContextRemovedEvent(ctxUID));
    }

    public void removeContextEvent(@Observes ContextRenderedEvent event) {
        if (this.contextToRemove.contains(event.getCtxUID())) {
            this.doRemovecontext(event.getCtxUID());
        }
    }

    public FormRenderContext newContext(Form form, Map<String, Object> ctx) {
        return this.newContext(form, ctx, new HashMap<String, Object>());
    }

    public FormRenderContext newContext(Form form, Map<String, Object> inputData, Map<String, Object> outputData) {
        String uid = "formRenderCtx_" + form.getId() + "_" + System.currentTimeMillis();
        return this.buildContext(uid, form, inputData, outputData);
    }

    public FormRenderContext newContext(Form form, Map<String, Object> inputData, Map<String, Object> outputData, Map<String, Object> forms) {
        String uid = "formRenderCtx_" + form.getId() + "_" + System.currentTimeMillis();
        return this.buildContext(uid, form, inputData, outputData, forms);
    }

    private FormRenderContext buildContext(String uid, Form form, Map<String, Object> inputData, Map<String, Object> outputData, Map<String, Object> forms) {
        FormRenderContext ctx = new FormRenderContext(uid, form, inputData, outputData);
        ctx.setContextForms(forms);
        this.formRenderContextMap.put(uid, ctx);
        this.formProcessor.read(ctx.getUID());
        return ctx;
    }

    private FormRenderContext buildContext(String uid, Form form, Map<String, Object> inputData, Map<String, Object> outputData) {
        return this.buildContext(uid, form, inputData, outputData, new HashMap<String, Object>());
    }

    public FormRenderContext getFormRenderContext(String UID) {
        return this.formRenderContextMap.get(UID);
    }

    public FormRenderContext getRootContext(String UID) {
        int separatorIndex = UID.indexOf("-");
        if (separatorIndex != -1) {
            UID = UID.substring(0, separatorIndex);
        }
        return this.formRenderContextMap.get(UID);
    }

    public void fireContextSubmitError(FormSubmitFailEvent event) {
        if (event != null) {
            this.formSubmitFailEvent.fire((Object)event);
        }
    }

    public void fireContextSubmit(FormSubmittedEvent event) {
        if (event != null) {
            this.formSubmittedEvent.fire((Object)event);
        }
    }
}

