/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers.radio;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.api.client.FormRenderContextManager;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.core.config.SelectValuesProvider;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

@Named(value="RadioGroupFieldHandlerFormatter")
public class RadioGroupFieldHandlerFormatter
extends DefaultFieldHandlerFormatter {
    public static final String PARAM_MODE = "show_mode";
    public static final String MODE_SHOW = "show";
    public static final String MODE_INPUT = "input";
    @Inject
    private FormRenderContextManager formRenderContextManager;

    public void service(HttpServletRequest request, HttpServletResponse response) throws FormatterException {
        String mode = (String)this.getParameter(PARAM_MODE);
        if (MODE_INPUT.equals(mode)) {
            this.renderInput(request);
        } else {
            this.renderShow(request);
        }
    }

    public void renderShow(HttpServletRequest request) throws FormatterException {
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(request);
        Field field = paramsReader.getCurrentField();
        if (StringUtils.isEmpty((CharSequence)field.getCustomFieldType())) {
            return;
        }
        Object value = paramsReader.getCurrentFieldValue();
        String fieldName = paramsReader.getCurrentFieldName();
        SelectValuesProvider provider = (SelectValuesProvider)CDIBeanLocator.getBeanByNameOrType((String)field.getCustomFieldType());
        Map fieldRange = provider.getSelectOptions(field, (String)value, this.formRenderContextManager.getRootContext(fieldName), this.getLocale());
        if (fieldRange == null || fieldRange.isEmpty()) {
            return;
        }
        String text = (String)fieldRange.get(value);
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        this.setAttribute("value", text);
        this.renderFragment("output");
    }

    public void renderInput(HttpServletRequest request) throws FormatterException {
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(request);
        Field field = paramsReader.getCurrentField();
        if (StringUtils.isEmpty((CharSequence)field.getCustomFieldType())) {
            return;
        }
        Object value = paramsReader.getCurrentFieldValue();
        String fieldName = paramsReader.getCurrentFieldName();
        SelectValuesProvider provider = (SelectValuesProvider)CDIBeanLocator.getBeanByNameOrType((String)field.getCustomFieldType());
        Map fieldRange = provider.getSelectOptions(field, (String)value, this.formRenderContextManager.getRootContext(fieldName), this.getLocale());
        if (fieldRange == null || fieldRange.isEmpty()) {
            return;
        }
        String uid = this.namespaceManager.squashInputName(fieldName);
        Boolean isReadonly = paramsReader.isFieldReadonly() != false || field.getReadonly() != false;
        String keyValueStr = String.valueOf(value);
        this.setAttribute("name", fieldName);
        this.setAttribute("uid", uid);
        this.setAttribute("value", keyValueStr);
        if (isReadonly.booleanValue()) {
            this.setAttribute("readonly", isReadonly);
        }
        this.renderFragment("outputStart");
        if (field.getVerticalAlignment().booleanValue()) {
            this.renderVertical(field, fieldName, paramsReader.isFieldReadonly(), uid, fieldRange, StringUtils.defaultString((String)((String)value)));
        } else {
            this.renderHorizontal(field, fieldName, paramsReader.isFieldReadonly(), uid, fieldRange, StringUtils.defaultString((String)((String)value)));
        }
        this.renderFragment("outputEnd");
    }

    protected void renderHorizontal(Field field, String fieldName, Boolean isReadonly, String uid, Map<String, String> fieldRange, String value) {
        int index = 0;
        int maxElements = this.getMaxElements(fieldRange, field);
        int cellCount = 0;
        Iterator<String> iter = fieldRange.keySet().iterator();
        while (iter.hasNext()) {
            if (cellCount == 0) {
                this.renderFragment("startRow");
            }
            String key = iter.next();
            String keyValue = fieldRange.get(key);
            this.renderFragment("startCell");
            this.renderRadio(key, keyValue, key.equals(value), fieldName, uid + "." + index++, isReadonly, field);
            this.renderFragment("endCell");
            if (++cellCount != maxElements) continue;
            cellCount = 0;
            this.renderFragment("endRow");
        }
    }

    protected void renderVertical(Field field, String fieldName, Boolean isReadonly, String uid, Map<String, String> fieldRange, String value) {
        int maxElements = this.getMaxElements(fieldRange, field);
        ArrayList radioTable = new ArrayList();
        int col = 0;
        Iterator<String> iter = fieldRange.keySet().iterator();
        while (iter.hasNext()) {
            if (radioTable.size() == col) {
                radioTable.add(new ArrayList());
            }
            List currentColumn = (List)radioTable.get(col);
            currentColumn.add(iter.next().toString());
            if (currentColumn.size() != maxElements) continue;
            ++col;
        }
        int index = 0;
        for (int row = 0; row < maxElements; ++row) {
            this.renderFragment("startRow");
            for (int i = 0; i < radioTable.size(); ++i) {
                List column = (List)radioTable.get(i);
                this.renderFragment("startCell");
                if (column.size() > row) {
                    String key = (String)column.get(row);
                    this.renderRadio(key, fieldRange.get(key), key.equals(value), fieldName, uid + "." + index++, isReadonly, field);
                }
                this.renderFragment("endCell");
            }
            this.renderFragment("endRow");
        }
    }

    protected void renderRadio(String key, String keyValue, Boolean checked, String fieldName, String uid, Boolean isReadonly, Field field) {
        this.setAttribute("name", fieldName);
        this.setAttribute("uid", uid);
        this.setAttribute("key", key);
        this.setAttribute("value", keyValue);
        this.setAttribute("checked", checked);
        this.setAttribute("readonly", isReadonly);
        this.setAttribute("onChangeScript", field.getOnChangeScript());
        this.setAttribute("cssStyle", field.getCssStyle());
        this.setAttribute("styleclass", field.getStyleclass());
        this.renderFragment("outputRadio");
    }

    protected int getMaxElements(Map<String, String> fieldRange, Field field) {
        int maxElements;
        int n = maxElements = field.getMaxlength() != null ? field.getMaxlength().intValue() : fieldRange.keySet().size();
        if (maxElements < 1) {
            maxElements = fieldRange.keySet().size();
        }
        return maxElements;
    }
}

