/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.report;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gwt.mosaic.ui.client.CaptionLayoutPanel;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.MosaicPanel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.report.ReportFrame;
import org.jboss.bpm.console.client.report.ReportParamCallback;
import org.jboss.bpm.console.client.report.ReportParameterForm;
import org.jboss.bpm.report.model.ReportReference;
import org.jboss.errai.workspaces.client.framework.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
class ReportLaunchPadView
extends MosaicPanel
implements ViewInterface,
DataDriven {
    public static final String ID = ReportLaunchPadView.class.getName();
    private Controller controller;
    private MosaicPanel inputPanel;
    private ListBox dropBox;
    List<ReportReference> reportTemplates;
    private HTML description;
    private ReportFrame reportFrame;
    private Map<String, ReportParameterForm> forms = new HashMap();

    public ReportLaunchPadView() {
        super((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        this.setPadding(5);
        CaptionLayoutPanel header = new CaptionLayoutPanel("Report configuration");
        header.setStyleName("bpm-detail-panel");
        header.setLayout((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
        MosaicPanel templatePanel = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        this.description = new HTML();
        this.dropBox = new ListBox(false);
        this.dropBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        templatePanel.add((Widget)this.dropBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        templatePanel.add((Widget)this.description, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        this.inputPanel = new MosaicPanel();
        header.add((Widget)templatePanel, (LayoutData)new BoxLayoutData("250 px", "100 px"));
        header.add((Widget)this.inputPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        this.reportFrame = new ReportFrame();
        this.add((Widget)header, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.add((Widget)this.reportFrame, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
    }

    private ReportParameterForm createInput(ReportReference reportRef) {
        ReportParameterForm form = new ReportParameterForm(reportRef, (ReportParamCallback)new /* Unavailable Anonymous Inner Class!! */);
        return form;
    }

    private ReportReference getCurrentSelection() {
        String template = this.dropBox.getItemText(this.dropBox.getSelectedIndex());
        for (ReportReference r : this.reportTemplates) {
            if (!r.getTitle().equals(template)) continue;
            return r;
        }
        return null;
    }

    public void update(List<ReportReference> reports) {
        this.reportTemplates = reports;
        this.forms.clear();
        for (ReportReference report : reports) {
            this.dropBox.addItem(report.getTitle());
            this.forms.put(report.getTitle(), this.createInput(report));
        }
        this.dropBox.setSelectedIndex(0);
        this.selectForm(this.dropBox.getItemText(0));
        ((ApplicationContext)Registry.get(ApplicationContext.class)).refreshView();
    }

    private void selectForm(String reportTitle) {
        this.inputPanel.clear();
        ReportReference current = this.getCurrentSelection();
        this.description.setText(current.getDescription());
        this.inputPanel.add((Widget)this.forms.get(reportTitle));
        this.layout();
    }

    public void displayReport(String title, String dispatchUrl) {
        this.reportFrame.setFrameUrl(dispatchUrl);
    }

    public void reset() {
        String url = GWT.getModuleBaseURL() + "blank.html";
        System.out.println("** Blank URL: " + url);
        this.displayReport("", url);
    }

    public void update(Object ... data) {
        String title = (String)data[0];
        String url = (String)data[1];
        this.displayReport(title, url);
    }

    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.reportFrame, (boolean)isLoading);
    }

    private static String fieldValues2PostParams(Map<String, String> values) {
        StringBuffer sb = new StringBuffer();
        for (String key : values.keySet()) {
            sb.append(key).append("=").append(values.get(key));
            sb.append(";");
        }
        System.out.println(sb.toString());
        return sb.toString();
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    static /* synthetic */ ListBox access$000(ReportLaunchPadView x0) {
        return x0.dropBox;
    }

    static /* synthetic */ void access$100(ReportLaunchPadView x0, String x1) {
        x0.selectForm(x1);
    }

    static /* synthetic */ String access$200(Map x0) {
        return ReportLaunchPadView.fieldValues2PostParams((Map)x0);
    }

    static /* synthetic */ Controller access$300(ReportLaunchPadView x0) {
        return x0.controller;
    }
}

